/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.permutations.ScrambleMutation;

public final class WindowLimitedScrambleMutation
extends ScrambleMutation {
    private final int limit;

    public WindowLimitedScrambleMutation() {
        this(Integer.MAX_VALUE);
    }

    public WindowLimitedScrambleMutation(int windowLimit) {
        if (windowLimit <= 0) {
            throw new IllegalArgumentException("window limit must be positive");
        }
        this.limit = windowLimit;
    }

    @Override
    public WindowLimitedScrambleMutation split() {
        return new WindowLimitedScrambleMutation(this.limit);
    }

    @Override
    final void generateIndexes(int n, int[] indexes) {
        if (this.limit >= n) {
            super.generateIndexes(n, indexes);
        } else {
            RandomIndexer.nextWindowedIntPair((int)n, (int)this.limit, (int[])indexes);
        }
    }
}

