/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.operators.permutations.SwapMutation;
import org.cicirello.search.operators.permutations.WindowLimitedSwapIterator;

public final class WindowLimitedSwapMutation
extends SwapMutation {
    private final int limit;

    public WindowLimitedSwapMutation() {
        this(Integer.MAX_VALUE);
    }

    public WindowLimitedSwapMutation(int windowLimit) {
        if (windowLimit <= 0) {
            throw new IllegalArgumentException("window limit must be positive");
        }
        this.limit = windowLimit;
    }

    @Override
    public WindowLimitedSwapMutation split() {
        return new WindowLimitedSwapMutation(this.limit);
    }

    @Override
    public MutationIterator iterator(Permutation p) {
        return new WindowLimitedSwapIterator(p, this.limit);
    }

    @Override
    final void generateIndexes(int n, int[] indexes) {
        if (this.limit >= n) {
            super.generateIndexes(n, indexes);
        } else {
            RandomIndexer.nextWindowedIntPair((int)n, (int)this.limit, (int[])indexes);
        }
    }
}

