/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.reals;

import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.search.operators.Initializer;
import org.cicirello.search.representations.SingleReal;

public final class RealValueInitializer
implements Initializer<SingleReal> {
    private final double a;
    private final double b;
    private final double min;
    private final double max;
    private final boolean bounded;

    public RealValueInitializer(double a, double b) {
        if (a >= b) {
            throw new IllegalArgumentException("a must be less than b");
        }
        this.a = a;
        this.b = b;
        this.bounded = false;
        this.max = 0.0;
        this.min = 0.0;
    }

    public RealValueInitializer(double a, double b, double min, double max) {
        if (a >= b) {
            throw new IllegalArgumentException("a must be less than b");
        }
        if (min > max) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        this.a = a <= min ? min : a;
        this.b = b > max ? max + Math.ulp(max) : b;
        this.min = min;
        this.max = max;
        this.bounded = true;
    }

    @Override
    public final SingleReal createCandidateSolution() {
        if (this.bounded) {
            return new BoundedReal(ThreadLocalRandom.current().nextDouble(this.a, this.b));
        }
        return new SingleReal(ThreadLocalRandom.current().nextDouble(this.a, this.b));
    }

    @Override
    public RealValueInitializer split() {
        return this;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RealValueInitializer)) {
            return false;
        }
        RealValueInitializer i = (RealValueInitializer)other;
        return this.a == i.a && this.b == i.b && this.min == i.min && this.max == i.max;
    }

    public int hashCode() {
        return 31 * (31 * (31 * (31 + Double.hashCode(this.a)) + Double.hashCode(this.b)) + Double.hashCode(this.min)) + Double.hashCode(this.max);
    }

    private final class BoundedReal
    extends SingleReal {
        public BoundedReal(double x) {
            this.set(x);
        }

        public BoundedReal(BoundedReal other) {
            super(other);
        }

        @Override
        public final void set(double x) {
            if (x < RealValueInitializer.this.min) {
                super.set(RealValueInitializer.this.min);
            } else if (x > RealValueInitializer.this.max) {
                super.set(RealValueInitializer.this.max);
            } else {
                super.set(x);
            }
        }

        @Override
        public BoundedReal copy() {
            return new BoundedReal(this);
        }

        private RealValueInitializer getOuterThis() {
            return RealValueInitializer.this;
        }

        @Override
        public boolean equals(Object other) {
            if (other == null || !(other instanceof BoundedReal) || !super.equals(other)) {
                return false;
            }
            BoundedReal a = (BoundedReal)other;
            return this.getOuterThis().equals(a.getOuterThis());
        }

        @Override
        public int hashCode() {
            long bitsMin = Double.doubleToLongBits(RealValueInitializer.this.min);
            long bitsMax = Double.doubleToLongBits(RealValueInitializer.this.max);
            return 31 * (31 * (31 + super.hashCode()) + (int)(bitsMin ^ bitsMin >>> 32)) + (int)(bitsMax ^ bitsMax >>> 32);
        }
    }
}

