/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.reals;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.search.operators.Initializer;
import org.cicirello.search.representations.BoundedRealVector;
import org.cicirello.search.representations.RealVector;

public final class RealVectorInitializer
implements Initializer<RealVector> {
    private final double[] x;
    private final double[] a;
    private final double[] b;
    private final double[] min;
    private final double[] max;

    public RealVectorInitializer(int n, double a, double b) {
        if (a >= b) {
            throw new IllegalArgumentException("a must be less than b");
        }
        this.x = new double[n];
        this.a = new double[]{a};
        this.b = new double[]{b};
        this.max = null;
        this.min = null;
    }

    public RealVectorInitializer(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("lengths of a and b must be identical");
        }
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] >= b[i])) continue;
            throw new IllegalArgumentException("a[i] must be less than b[i]");
        }
        this.x = new double[a.length];
        this.a = (double[])a.clone();
        this.b = (double[])b.clone();
        this.max = null;
        this.min = null;
    }

    public RealVectorInitializer(int n, double a, double b, double min, double max) {
        if (a >= b) {
            throw new IllegalArgumentException("a must be less than b");
        }
        if (min > max) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        this.x = new double[n];
        this.a = new double[]{a <= min ? min : a};
        this.b = new double[]{b > max ? max + Math.ulp(max) : b};
        this.min = new double[]{min};
        this.max = new double[]{max};
    }

    public RealVectorInitializer(double[] a, double[] b, double min, double max) {
        int i;
        if (a.length != b.length) {
            throw new IllegalArgumentException("lengths of a and b must be identical");
        }
        if (min > max) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        for (i = 0; i < a.length; ++i) {
            if (!(a[i] >= b[i])) continue;
            throw new IllegalArgumentException("a[i] must be less than b[i]");
        }
        this.x = new double[a.length];
        this.a = new double[a.length];
        this.b = new double[b.length];
        for (i = 0; i < a.length; ++i) {
            this.a[i] = a[i] <= min ? min : a[i];
            this.b[i] = b[i] > max ? max + Math.ulp(max) : b[i];
        }
        this.min = new double[]{min};
        this.max = new double[]{max};
    }

    public RealVectorInitializer(double[] a, double[] b, double[] min, double[] max) {
        int i;
        if (a.length != b.length || min.length != max.length || a.length != min.length) {
            throw new IllegalArgumentException("lengths of a, b, min, and max must be identical");
        }
        for (i = 0; i < a.length; ++i) {
            if (a[i] >= b[i]) {
                throw new IllegalArgumentException("a[i] must be less than b[i]");
            }
            if (!(min[i] > max[i])) continue;
            throw new IllegalArgumentException("min[i] must be less than or equal to max[i]");
        }
        this.x = new double[a.length];
        this.a = new double[a.length];
        this.b = new double[b.length];
        for (i = 0; i < a.length; ++i) {
            this.a[i] = a[i] <= min[i] ? min[i] : a[i];
            this.b[i] = b[i] > max[i] ? max[i] + Math.ulp(max[i]) : b[i];
        }
        this.min = (double[])min.clone();
        this.max = (double[])max.clone();
    }

    private RealVectorInitializer(RealVectorInitializer other) {
        this.min = other.min == null ? null : (double[])other.min.clone();
        this.max = other.max == null ? null : (double[])other.max.clone();
        this.a = (double[])other.a.clone();
        this.b = (double[])other.b.clone();
        this.x = new double[this.a.length];
    }

    @Override
    public final RealVector createCandidateSolution() {
        if (this.a.length > 1) {
            for (int i = 0; i < this.x.length; ++i) {
                this.x[i] = ThreadLocalRandom.current().nextDouble(this.a[i], this.b[i]);
            }
        } else {
            for (int i = 0; i < this.x.length; ++i) {
                this.x[i] = ThreadLocalRandom.current().nextDouble(this.a[0], this.b[0]);
            }
        }
        if (this.min != null) {
            return this.min.length > 1 ? new MultiBoundedRealVector(this.x) : new BoundedRealVector(this.x, this.min[0], this.max[0]);
        }
        return new RealVector(this.x);
    }

    @Override
    public RealVectorInitializer split() {
        return new RealVectorInitializer(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RealVectorInitializer)) {
            return false;
        }
        RealVectorInitializer i = (RealVectorInitializer)other;
        return (this.min == null && i.min == null || Arrays.equals(this.min, i.min) && Arrays.equals(this.max, i.max)) && Arrays.equals(this.a, i.a) && Arrays.equals(this.b, i.b);
    }

    public int hashCode() {
        int h = 31 * Arrays.hashCode(this.a) + Arrays.hashCode(this.b);
        if (this.min != null) {
            h = 31 * (31 * h + Arrays.hashCode(this.min)) + Arrays.hashCode(this.max);
        }
        return h;
    }

    private final class MultiBoundedRealVector
    extends RealVector {
        public MultiBoundedRealVector(double[] x) {
            super(x.length);
            this.setAll(x);
        }

        public MultiBoundedRealVector(MultiBoundedRealVector other) {
            super(other);
        }

        @Override
        public final void set(int i, double value) {
            if (value < RealVectorInitializer.this.min[i]) {
                super.set(i, RealVectorInitializer.this.min[i]);
            } else if (value > RealVectorInitializer.this.max[i]) {
                super.set(i, RealVectorInitializer.this.max[i]);
            } else {
                super.set(i, value);
            }
        }

        private void setAll(double[] x) {
            for (int i = 0; i < x.length; ++i) {
                super.set(i, x[i]);
            }
        }

        @Override
        public MultiBoundedRealVector copy() {
            return new MultiBoundedRealVector(this);
        }

        private RealVectorInitializer getOuterThis() {
            return RealVectorInitializer.this;
        }

        @Override
        public boolean equals(Object other) {
            if (!super.equals(other)) {
                return false;
            }
            MultiBoundedRealVector b = (MultiBoundedRealVector)other;
            return this.getOuterThis().equals(b.getOuterThis());
        }

        @Override
        public int hashCode() {
            long bitsV;
            int hash = 1;
            for (double v : RealVectorInitializer.this.min) {
                bitsV = Double.doubleToLongBits(v);
                hash = 31 * hash + (int)(bitsV ^ bitsV >>> 32);
            }
            for (double v : RealVectorInitializer.this.max) {
                bitsV = Double.doubleToLongBits(v);
                hash = 31 * hash + (int)(bitsV ^ bitsV >>> 32);
            }
            int L = this.length();
            for (int i = 0; i < L; ++i) {
                long bitsV2 = Double.doubleToLongBits(this.get(i));
                hash = 31 * hash + (int)(bitsV2 ^ bitsV2 >>> 32);
            }
            return hash;
        }
    }
}

