/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.reals;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.CrossoverOperator;
import org.cicirello.search.representations.RealVector;

public final class TwoPointCrossover<T extends RealVector>
implements CrossoverOperator<T> {
    private final int[] indexes = new int[2];

    @Override
    public void cross(RealVector c1, RealVector c2) {
        RandomIndexer.nextIntPair((int)c1.length(), (int[])this.indexes);
        if (this.indexes[1] > this.indexes[0]) {
            RealVector.exchange(c1, c2, this.indexes[0], this.indexes[1] - 1);
        } else {
            RealVector.exchange(c1, c2, this.indexes[1], this.indexes[0] - 1);
        }
    }

    @Override
    public TwoPointCrossover<T> split() {
        return new TwoPointCrossover<T>();
    }
}

