/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.reals;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.UndoableMutationOperator;
import org.cicirello.search.operators.reals.UniformMutation;
import org.cicirello.search.representations.RealValued;

public class UndoableUniformMutation<T extends RealValued>
extends UniformMutation<T>
implements UndoableMutationOperator<T> {
    double[] previous;
    double old;

    UndoableUniformMutation(double radius) {
        super(radius);
    }

    UndoableUniformMutation(UndoableUniformMutation<T> other) {
        super(other);
    }

    public static <T extends RealValued> UndoableUniformMutation<T> createUniformMutation() {
        return new UndoableUniformMutation<T>(1.0);
    }

    public static <T extends RealValued> UndoableUniformMutation<T> createUniformMutation(double radius) {
        return new UndoableUniformMutation<T>(radius);
    }

    public static <T extends RealValued> UndoableUniformMutation<T> createUniformMutation(double radius, int k) {
        if (k < 1) {
            throw new IllegalArgumentException("k must be at least 1");
        }
        return new UndoablePartialUniformMutation(radius, k);
    }

    public static <T extends RealValued> UndoableUniformMutation<T> createUniformMutation(double radius, double p) {
        if (p <= 0.0) {
            throw new IllegalArgumentException("p must be positive");
        }
        return p >= 1.0 ? new UndoableUniformMutation<T>(radius) : new UndoablePartialUniformMutation(radius, p);
    }

    @Override
    public void mutate(T c) {
        if (c.length() > 1) {
            this.previous = c.toArray(this.previous);
            this.internalMutate(c, this.previous);
        } else if (c.length() == 1) {
            this.old = c.get(0);
            this.internalMutate(c, this.old);
        }
    }

    @Override
    public void undo(T c) {
        if (c.length() > 1) {
            for (int i = 0; i < c.length(); ++i) {
                c.set(i, this.previous[i]);
            }
        } else if (c.length() == 1) {
            c.set(0, this.old);
        }
    }

    @Override
    public UndoableUniformMutation<T> split() {
        return new UndoableUniformMutation<T>(this);
    }

    @Override
    public UndoableUniformMutation<T> copy() {
        return new UndoableUniformMutation<T>(this);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && other instanceof UndoableUniformMutation;
    }

    private static final class UndoablePartialUniformMutation<T extends RealValued>
    extends UndoableUniformMutation<T> {
        private final int k;
        private final double p;
        private int[] indexes;

        UndoablePartialUniformMutation(double radius, int k) {
            super(radius);
            this.k = k;
            this.p = -1.0;
        }

        UndoablePartialUniformMutation(double radius, double p) {
            super(radius);
            this.p = p;
            this.k = 0;
        }

        UndoablePartialUniformMutation(UndoablePartialUniformMutation<T> other) {
            super(other);
            this.k = other.k;
            this.p = other.p;
        }

        @Override
        public void mutate(T c) {
            if (this.k >= c.length()) {
                super.mutate(c);
            } else {
                int[] nArray = this.indexes = this.p < 0.0 ? RandomIndexer.sample((int)c.length(), (int)this.k, (int[])this.indexes) : RandomIndexer.sample((int)c.length(), (double)this.p);
                if (this.previous == null || this.previous.length < this.indexes.length) {
                    this.previous = new double[this.indexes.length];
                }
                for (int i = 0; i < this.indexes.length; ++i) {
                    this.previous[i] = c.get(this.indexes[i]);
                }
                this.internalPartialMutation(c, this.indexes, this.previous);
            }
        }

        @Override
        public void undo(T c) {
            if (this.k >= c.length()) {
                super.undo(c);
            } else {
                for (int i = 0; i < this.indexes.length; ++i) {
                    c.set(this.indexes[i], this.previous[i]);
                }
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other == null || !(other instanceof UndoablePartialUniformMutation)) {
                return false;
            }
            if (!super.equals(other)) {
                return false;
            }
            UndoablePartialUniformMutation g = (UndoablePartialUniformMutation)other;
            return this.k == g.k && this.p == g.p;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + (this.p < 0.0 ? this.k : Double.hashCode(this.p));
        }

        @Override
        public UndoablePartialUniformMutation<T> split() {
            return new UndoablePartialUniformMutation<T>(this);
        }

        @Override
        public UndoablePartialUniformMutation<T> copy() {
            return new UndoablePartialUniformMutation<T>(this);
        }
    }
}

