/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.reals;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.CrossoverOperator;
import org.cicirello.search.representations.RealVector;

public final class UniformCrossover<T extends RealVector>
implements CrossoverOperator<T> {
    private final double p;

    public UniformCrossover() {
        this.p = 0.5;
    }

    public UniformCrossover(double p) {
        this.p = p <= 0.0 ? 0.0 : (p >= 1.0 ? 1.0 : p);
    }

    @Override
    public void cross(RealVector c1, RealVector c2) {
        int[] indexes;
        for (int i : indexes = RandomIndexer.sample((int)c1.length(), (double)this.p)) {
            double temp = c1.get(i);
            c1.set(i, c2.get(i));
            c2.set(i, temp);
        }
    }

    @Override
    public UniformCrossover<T> split() {
        return this;
    }
}

