/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems;

import org.cicirello.search.operators.integers.IntegerVectorInitializer;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.representations.IntegerVector;

public final class BoundMax
extends IntegerVectorInitializer
implements IntegerCostOptimizationProblem<IntegerVector> {
    private final int b;
    private final int n;

    public BoundMax(int n, int bound) {
        super(n, 0, bound + 1, 0, bound);
        this.b = bound;
        this.n = n;
    }

    @Override
    public int cost(IntegerVector candidate) {
        return this.n - this.value(candidate);
    }

    @Override
    public int value(IntegerVector candidate) {
        if (candidate == null) {
            return 0;
        }
        int sum = 0;
        int m = candidate.length() < this.n ? candidate.length() : this.n;
        for (int i = 0; i < m; ++i) {
            if (candidate.get(i) != this.b) continue;
            ++sum;
        }
        return sum;
    }

    @Override
    public int minCost() {
        return 0;
    }

    @Override
    public boolean isMinCost(int cost) {
        return cost == 0;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof BoundMax)) {
            return false;
        }
        BoundMax o = (BoundMax)other;
        return this.b == o.b && this.n == o.n;
    }
}

