/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems;

import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.util.Copyable;

public final class CostFunctionScaler<T extends Copyable<T>>
implements OptimizationProblem<T> {
    private final OptimizationProblem<T> problem;
    private final double scale;

    public CostFunctionScaler(OptimizationProblem<T> problem, double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("scale must be positive");
        }
        this.scale = scale;
        this.problem = problem;
    }

    @Override
    public double cost(T candidate) {
        return this.scale * this.problem.cost(candidate);
    }

    @Override
    public double minCost() {
        return this.scale * this.problem.minCost();
    }

    @Override
    public double value(T candidate) {
        return this.problem.value(candidate);
    }
}

