/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems;

import org.cicirello.search.operators.Initializer;
import org.cicirello.search.operators.reals.RealValueInitializer;
import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.representations.SingleReal;

public final class ForresterEtAl2008
implements OptimizationProblem<SingleReal>,
Initializer<SingleReal> {
    private final boolean ORIGINAL;
    private final double A;
    private final double B;
    private final double C;
    private final RealValueInitializer init;

    public ForresterEtAl2008() {
        this(false);
    }

    public ForresterEtAl2008(boolean lowerFidelity) {
        boolean bl = this.ORIGINAL = !lowerFidelity;
        if (this.ORIGINAL) {
            this.A = 1.0;
            this.C = 0.0;
            this.B = 0.0;
        } else {
            this.A = 0.5;
            this.B = 10.0;
            this.C = -5.0;
        }
        this.init = new RealValueInitializer(0.0, 1.0, 0.0, 1.0);
    }

    @Override
    public double cost(SingleReal candidate) {
        if (this.ORIGINAL) {
            return this.original(candidate);
        }
        return this.A * this.original(candidate) + this.B * (candidate.get() - 0.5) - this.C;
    }

    @Override
    public double value(SingleReal candidate) {
        return this.cost(candidate);
    }

    @Override
    public SingleReal createCandidateSolution() {
        return this.init.createCandidateSolution();
    }

    @Override
    public ForresterEtAl2008 split() {
        return new ForresterEtAl2008(!this.ORIGINAL);
    }

    private double original(SingleReal candidate) {
        double term = 6.0 * candidate.get() - 2.0;
        return term * term * Math.sin(12.0 * candidate.get() - 4.0);
    }
}

