/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems;

import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.util.Copyable;

public final class IntegerCostFunctionScaler<T extends Copyable<T>>
implements IntegerCostOptimizationProblem<T> {
    private final IntegerCostOptimizationProblem<T> problem;
    private final int scale;

    public IntegerCostFunctionScaler(IntegerCostOptimizationProblem<T> problem, int scale) {
        if (scale <= 0) {
            throw new IllegalArgumentException("scale must be positive");
        }
        this.scale = scale;
        this.problem = problem;
    }

    @Override
    public int cost(T candidate) {
        return this.scale * this.problem.cost(candidate);
    }

    @Override
    public int minCost() {
        return this.scale * this.problem.minCost();
    }

    @Override
    public int value(T candidate) {
        return this.problem.value(candidate);
    }
}

