/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems;

import java.util.ArrayList;
import java.util.List;
import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.representations.BitVector;

public final class LargestCommonSubgraph
implements IntegerCostOptimizationProblem<Permutation> {
    private final ArrayList<InternalEdge> edgesG1 = new ArrayList();
    private final BitVector[] adjacencyMatrixG2;
    private int bound;

    public LargestCommonSubgraph(int v, double density, boolean isomorphic) {
        this(v);
        if (isomorphic) {
            this.createIsomorphicRandomInstanceData(v, density, new SplittableRandom());
        } else {
            this.createRandomInstanceData(v, v, density, density, new SplittableRandom());
        }
    }

    public LargestCommonSubgraph(int v1, int v2, double density1, double density2) {
        this(v2 > v1 ? v2 : v1);
        if (v1 < v2 || v1 == v2 && density1 <= density2) {
            this.createRandomInstanceData(v1, v2, density1, density2, new SplittableRandom());
        } else {
            this.createRandomInstanceData(v2, v1, density2, density1, new SplittableRandom());
        }
    }

    public LargestCommonSubgraph(int v, double density, boolean isomorphic, long seed) {
        this(v);
        if (isomorphic) {
            this.createIsomorphicRandomInstanceData(v, density, new SplittableRandom(seed));
        } else {
            this.createRandomInstanceData(v, v, density, density, new SplittableRandom(seed));
        }
    }

    public LargestCommonSubgraph(int v1, int v2, double density1, double density2, long seed) {
        this(v2 > v1 ? v2 : v1);
        if (v1 < v2 || v1 == v2 && density1 <= density2) {
            this.createRandomInstanceData(v1, v2, density1, density2, new SplittableRandom(seed));
        } else {
            this.createRandomInstanceData(v2, v1, density2, density1, new SplittableRandom(seed));
        }
    }

    public LargestCommonSubgraph(int v1, int v2, List<Edge> edges1, List<Edge> edges2) {
        this(v2 > v1 ? v2 : v1);
        if (v1 < v2 || v1 == v2 && edges1.size() <= edges2.size()) {
            this.initializeInstanceData(v1, v2, edges1, edges2);
        } else {
            this.initializeInstanceData(v2, v1, edges2, edges1);
        }
    }

    public static LargestCommonSubgraph createInstanceGeneralizedPetersenGraph(int n, int k) {
        return LargestCommonSubgraph.createInstanceGeneralizedPetersenGraph(n, k, new Permutation(2 * n));
    }

    public static LargestCommonSubgraph createInstanceGeneralizedPetersenGraph(int n, int k, long seed) {
        return LargestCommonSubgraph.createInstanceGeneralizedPetersenGraph(n, k, new Permutation(2 * n, (RandomGenerator)new SplittableRandom(seed)));
    }

    private LargestCommonSubgraph(int largerV) {
        this.adjacencyMatrixG2 = new BitVector[largerV];
    }

    public int size() {
        return this.adjacencyMatrixG2.length;
    }

    @Override
    public int cost(Permutation candidate) {
        return this.bound - this.value(candidate);
    }

    @Override
    public int value(Permutation candidate) {
        int count = 0;
        for (InternalEdge e : this.edgesG1) {
            if (!this.adjacencyMatrixG2[candidate.get(e.x)].isOne(candidate.get(e.y))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int minCost() {
        return 0;
    }

    public int maxValue() {
        return this.bound;
    }

    final boolean hasEdge1(int u, int v) {
        for (InternalEdge e : this.edgesG1) {
            if ((e.x != u || e.y != v) && (e.x != v || e.y != u)) continue;
            return true;
        }
        return false;
    }

    final boolean hasEdge2(int u, int v) {
        return this.adjacencyMatrixG2[u].isOne(v);
    }

    private void createIsomorphicRandomInstanceData(int v, double density, RandomGenerator gen) {
        if (v <= 0) {
            throw new IllegalArgumentException("Graphs must have at least 1 vertex.");
        }
        if (density < 0.0) {
            throw new IllegalArgumentException("The graph density must be non-negative.");
        }
        if (density > 1.0) {
            throw new IllegalArgumentException("The graph density must be no greater than 1.0.");
        }
        for (int i = 0; i < v; ++i) {
            this.adjacencyMatrixG2[i] = new BitVector(v);
        }
        Permutation perm = new Permutation(v, gen);
        for (int i = 0; i < v; ++i) {
            for (int j = i + 1; j < v; ++j) {
                if (!(gen.nextDouble() < density)) continue;
                this.edgesG1.add(new InternalEdge(i, j));
                this.adjacencyMatrixG2[perm.get(i)].flip(perm.get(j));
                this.adjacencyMatrixG2[perm.get(j)].flip(perm.get(i));
            }
        }
        this.bound = this.edgesG1.size();
    }

    private void createRandomInstanceData(int v1, int v2, double density1, double density2, RandomGenerator gen) {
        int j;
        int i;
        if (v1 <= 0) {
            throw new IllegalArgumentException("Graphs must have at least 1 vertex.");
        }
        if (density1 < 0.0 || density2 < 0.0) {
            throw new IllegalArgumentException("The graph density must be non-negative.");
        }
        if (density1 > 1.0 || density2 > 1.0) {
            throw new IllegalArgumentException("The graph density must be no greater than 1.0.");
        }
        for (i = 0; i < v1; ++i) {
            for (j = i + 1; j < v1; ++j) {
                if (!(gen.nextDouble() < density1)) continue;
                this.edgesG1.add(new InternalEdge(i, j));
            }
        }
        for (i = 0; i < v2; ++i) {
            this.adjacencyMatrixG2[i] = new BitVector(v2);
        }
        this.bound = 0;
        for (i = 0; i < v2; ++i) {
            for (j = i + 1; j < v2; ++j) {
                if (!(gen.nextDouble() < density2)) continue;
                this.adjacencyMatrixG2[i].flip(j);
                this.adjacencyMatrixG2[j].flip(i);
                ++this.bound;
            }
        }
        if (this.edgesG1.size() < this.bound) {
            this.bound = this.edgesG1.size();
        }
    }

    private void initializeInstanceData(int v1, int v2, List<Edge> edges1, List<Edge> edges2) {
        if (v1 <= 0) {
            throw new IllegalArgumentException("Graphs must have at least 1 vertex.");
        }
        for (Edge e : edges1) {
            if (e.u >= v1 || e.v >= v1) {
                throw new IllegalArgumentException("Edge endpoint out of bounds.");
            }
            this.edgesG1.add(new InternalEdge(e));
        }
        for (int i = 0; i < v2; ++i) {
            this.adjacencyMatrixG2[i] = new BitVector(v2);
        }
        for (Edge e : edges2) {
            if (e.u >= v2 || e.v >= v2) {
                throw new IllegalArgumentException("Edge endpoint out of bounds.");
            }
            this.adjacencyMatrixG2[e.u].flip(e.v);
            this.adjacencyMatrixG2[e.v].flip(e.u);
        }
        this.bound = edges1.size() <= edges2.size() ? edges1.size() : edges2.size();
    }

    private static LargestCommonSubgraph createInstanceGeneralizedPetersenGraph(int n, int k, Permutation p) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if (k > (n - 1) / 2) {
            throw new IllegalArgumentException("k must be less than 0.5n");
        }
        if (k < 0) {
            throw new IllegalArgumentException("k must be non-negative");
        }
        int[] u = new int[n];
        int[] v = new int[n];
        for (int i = 0; i < n; ++i) {
            u[i] = i;
            v[i] = n + i;
        }
        ArrayList<Edge> edges1 = new ArrayList<Edge>();
        for (int i = 0; i < n; ++i) {
            edges1.add(new Edge(u[i], u[(i + 1) % n]));
            edges1.add(new Edge(v[i], v[(i + k) % n]));
            edges1.add(new Edge(u[i], v[i]));
        }
        ArrayList<Edge> edges2 = new ArrayList<Edge>();
        for (Edge e : edges1) {
            edges2.add(new Edge(p.get(e.u), p.get(e.v)));
        }
        return new LargestCommonSubgraph(2 * n, 2 * n, edges1, edges2);
    }

    private class InternalEdge {
        private final int x;
        private final int y;

        private InternalEdge(int x, int y) {
            this.x = x;
            this.y = y;
        }

        private InternalEdge(Edge e) {
            this.x = e.u;
            this.y = e.v;
        }
    }

    public static final class Edge {
        private final int u;
        private final int v;

        public Edge(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public int getU() {
            return this.u;
        }

        public int getV() {
            return this.v;
        }
    }
}

