/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems;

import org.cicirello.search.problems.OneMaxAckley;
import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.problems.Porcupine;
import org.cicirello.search.problems.Trap;
import org.cicirello.search.problems.TwoMax;
import org.cicirello.search.representations.BitVector;

public final class Mix
implements OptimizationProblem<BitVector> {
    private final OneMaxAckley onemax = new OneMaxAckley();
    private final TwoMax twomax = new TwoMax();
    private final Trap trap = new Trap();
    private final Porcupine porcupine = new Porcupine();

    @Override
    public double cost(BitVector candidate) {
        return (double)(10 * candidate.length()) - this.value(candidate);
    }

    @Override
    public double minCost() {
        return 0.0;
    }

    @Override
    public double value(BitVector candidate) {
        int i;
        int m = candidate.length() / 5;
        int r = candidate.length() % 5;
        BitVector[] subVectors = new BitVector[5];
        BitVector.BitIterator iter = candidate.bitIterator();
        for (i = r; i < 5; ++i) {
            subVectors[i] = new BitVector(m, iter.nextLargeBitBlock(m));
        }
        if (r > 0) {
            ++m;
            for (i = 0; i < r; ++i) {
                subVectors[i] = new BitVector(m, iter.nextLargeBitBlock(m));
            }
        }
        int plateauValue = subVectors[4].allOnes() ? 10 * subVectors[4].length() : 0;
        return (double)(this.onemax.value(subVectors[0]) + this.twomax.value(subVectors[1])) + this.trap.value(subVectors[2]) + (double)this.porcupine.value(subVectors[3]) + (double)plateauValue;
    }

    @Override
    public boolean isMinCost(double cost) {
        return cost == 0.0;
    }
}

