/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.PermutationDistanceMeasurer;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;

public final class PermutationInAHaystack
implements IntegerCostOptimizationProblem<Permutation> {
    private final PermutationDistanceMeasurer distance;
    private final Permutation target;

    public PermutationInAHaystack(PermutationDistanceMeasurer distance, int n) {
        this.distance = distance;
        int[] p = new int[n];
        for (int i = 0; i < n; ++i) {
            p[i] = i;
        }
        this.target = new Permutation(p);
    }

    public PermutationInAHaystack(PermutationDistanceMeasurer distance, Permutation target) {
        this.distance = distance;
        this.target = new Permutation(target);
    }

    @Override
    public int cost(Permutation candidate) {
        return this.distance.distance(candidate, this.target);
    }

    @Override
    public int minCost() {
        return 0;
    }

    @Override
    public int value(Permutation candidate) {
        return this.distance.distance(candidate, this.target);
    }

    @Override
    public boolean isMinCost(int cost) {
        return cost == 0;
    }
}

