/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems;

import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.representations.SingleReal;

public final class PolynomialRootFinding
implements OptimizationProblem<SingleReal> {
    private final double[] coefficients;
    private final double precision;
    public static final double DEFAULT_PRECISION = 1.0E-10;

    public PolynomialRootFinding(double a, double b, double c) {
        this(a, b, c, 1.0E-10);
    }

    public PolynomialRootFinding(double a, double b, double c, double precision) {
        this.coefficients = new double[3];
        this.coefficients[0] = c;
        this.coefficients[1] = b;
        this.coefficients[2] = a;
        this.precision = precision;
    }

    public PolynomialRootFinding(double[] coefficients) {
        this(coefficients, 1.0E-10);
    }

    public PolynomialRootFinding(double[] coefficients, double precision) {
        if (coefficients.length < 2) {
            throw new IllegalArgumentException("Degree of the polynomial must be at least 1.");
        }
        this.coefficients = (double[])coefficients.clone();
        this.precision = precision;
    }

    @Override
    public double cost(SingleReal candidate) {
        double x;
        double c = this.coefficients[0];
        double term = x = candidate.get(0);
        int last = this.coefficients.length - 1;
        for (int i = 1; i < last; ++i) {
            c += this.coefficients[i] * term;
            term *= x;
        }
        return Math.abs(c += this.coefficients[last] * term);
    }

    @Override
    public double minCost() {
        return 0.0;
    }

    @Override
    public boolean isMinCost(double cost) {
        return Math.abs(cost) <= this.precision;
    }

    @Override
    public double value(SingleReal candidate) {
        return this.cost(candidate);
    }
}

