/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems;

import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;

public final class QuadraticAssignmentProblem
implements IntegerCostOptimizationProblem<Permutation> {
    private final int[][] cost;
    private final int[][] distance;

    QuadraticAssignmentProblem(int[][] cost, int[][] distance) {
        this.cost = cost;
        this.distance = distance;
    }

    @Override
    public int cost(Permutation candidate) {
        int total = 0;
        for (int i = 0; i < this.cost.length; ++i) {
            for (int j = i + 1; j < this.cost.length; ++j) {
                total += this.cost[i][j] * this.distance[candidate.get(i)][candidate.get(j)];
                total += this.cost[j][i] * this.distance[candidate.get(j)][candidate.get(i)];
            }
        }
        return total;
    }

    @Override
    public int value(Permutation candidate) {
        return this.cost(candidate);
    }

    @Override
    public int minCost() {
        return 0;
    }

    public int size() {
        return this.cost.length;
    }

    public int getCost(int i, int j) {
        return this.cost[i][j];
    }

    public int getDistance(int i, int j) {
        return this.distance[i][j];
    }

    public static QuadraticAssignmentProblem createInstance(int[][] cost, int[][] distance) {
        if (cost.length != distance.length) {
            throw new IllegalArgumentException("cost and distance matrices must have same number of rows");
        }
        int[][] costPrime = new int[cost.length][];
        int[][] distancePrime = new int[distance.length][];
        for (int i = 0; i < cost.length; ++i) {
            if (cost[i].length != cost.length || distance[i].length != cost.length) {
                throw new IllegalArgumentException("cost and distance matrices must be square");
            }
            costPrime[i] = (int[])cost[i].clone();
            distancePrime[i] = (int[])distance[i].clone();
        }
        return new QuadraticAssignmentProblem(costPrime, distancePrime);
    }

    public static QuadraticAssignmentProblem createUniformRandomInstance(int size, int minCost, int maxCost, int minDistance, int maxDistance) {
        return QuadraticAssignmentProblem.createUniformRandomInstance(size, minCost, maxCost, minDistance, maxDistance, new SplittableRandom());
    }

    public static QuadraticAssignmentProblem createUniformRandomInstance(int size, int minCost, int maxCost, int minDistance, int maxDistance, long seed) {
        return QuadraticAssignmentProblem.createUniformRandomInstance(size, minCost, maxCost, minDistance, maxDistance, new SplittableRandom(seed));
    }

    private static QuadraticAssignmentProblem createUniformRandomInstance(int size, int minCost, int maxCost, int minDistance, int maxDistance, RandomGenerator gen) {
        if (size < 1) {
            throw new IllegalArgumentException("size must be at least 1");
        }
        if (maxCost < minCost) {
            throw new IllegalArgumentException("maxCost must be at least minCost");
        }
        if (maxDistance < minDistance) {
            throw new IllegalArgumentException("maxDistance must be at least minDistance");
        }
        return new QuadraticAssignmentProblem(QuadraticAssignmentProblem.createRandomMatrix(size, minCost, maxCost, gen), QuadraticAssignmentProblem.createRandomMatrix(size, minDistance, maxDistance, gen));
    }

    private static int[][] createRandomMatrix(int size, int min, int max, RandomGenerator gen) {
        int[][] matrix = new int[size][size];
        int bound = max - min + 1;
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                matrix[i][j] = min + RandomIndexer.nextInt((int)bound, (RandomGenerator)gen);
                matrix[j][i] = min + RandomIndexer.nextInt((int)bound, (RandomGenerator)gen);
            }
        }
        return matrix;
    }
}

