/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblemData;

public final class CommonDuedateScheduling
implements SingleMachineSchedulingProblemData {
    public static final int MIN_PROCESS_TIME = 1;
    public static final int MAX_PROCESS_TIME = 20;
    public static final int MIN_EARLINESS_WEIGHT = 1;
    public static final int MAX_EARLINESS_WEIGHT = 10;
    public static final int MIN_TARDINESS_WEIGHT = 1;
    public static final int MAX_TARDINESS_WEIGHT = 15;
    private final int[] process;
    private final int[] earlyWeights;
    private final int[] weights;
    private final int duedate;

    public CommonDuedateScheduling(int n, double h) {
        this(n, h, new SplittableRandom());
    }

    public CommonDuedateScheduling(int n, double h, long seed) {
        this(n, h, new SplittableRandom(seed));
    }

    public CommonDuedateScheduling(String filename, int instanceNumber, double h) throws FileNotFoundException {
        this(new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8), instanceNumber, h);
    }

    private CommonDuedateScheduling(int n, double h, RandomGenerator generator) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be nonnegative");
        }
        if (h < 0.0 || h > 1.0) {
            throw new IllegalArgumentException("h must be in [0.0, 1.0]");
        }
        this.process = new int[n];
        this.earlyWeights = new int[n];
        this.weights = new int[n];
        int P_RANGE = 20;
        int E_RANGE = 10;
        int T_RANGE = 15;
        int totalP = 0;
        for (int i = 0; i < n; ++i) {
            this.process[i] = 1 + RandomIndexer.nextInt((int)20, (RandomGenerator)generator);
            totalP += this.process[i];
            this.earlyWeights[i] = 1 + RandomIndexer.nextInt((int)10, (RandomGenerator)generator);
            this.weights[i] = 1 + RandomIndexer.nextInt((int)15, (RandomGenerator)generator);
        }
        this.duedate = (int)((double)totalP * h);
    }

    CommonDuedateScheduling(Readable file, int instanceNumber, double h) {
        if (instanceNumber < 0) {
            throw new IllegalArgumentException("instanceNumber must be nonnegative");
        }
        if (h < 0.0 || h > 1.0) {
            throw new IllegalArgumentException("h must be in [0.0, 1.0]");
        }
        Scanner in = new Scanner(file);
        String line = in.nextLine();
        Scanner lineScanner = new Scanner(line);
        int numInstances = lineScanner.nextInt();
        lineScanner.close();
        if (instanceNumber >= numInstances) {
            in.close();
            throw new IllegalArgumentException("instanceNumber is too high.");
        }
        for (int i = 0; i < instanceNumber; ++i) {
            this.skipInstance(in);
        }
        line = in.nextLine();
        lineScanner = new Scanner(line);
        int numJobs = lineScanner.nextInt();
        lineScanner.close();
        this.process = new int[numJobs];
        this.earlyWeights = new int[numJobs];
        this.weights = new int[numJobs];
        int totalP = 0;
        for (int i = 0; i < numJobs; ++i) {
            lineScanner = new Scanner(in.nextLine());
            this.process[i] = lineScanner.nextInt();
            totalP += this.process[i];
            this.earlyWeights[i] = lineScanner.nextInt();
            this.weights[i] = lineScanner.nextInt();
            lineScanner.close();
        }
        this.duedate = (int)((double)totalP * h);
        in.close();
    }

    @Override
    public int[] getCompletionTimes(Permutation schedule) {
        int j;
        if (schedule.length() != this.process.length) {
            throw new IllegalArgumentException("schedule is incorrect length");
        }
        int[] c = new int[this.process.length];
        int time = 0;
        int earlyTotal = 0;
        int tardyTotal = 0;
        int firstTardy = -1;
        int lastEarly = -1;
        for (int i = 0; i < c.length; ++i) {
            j = schedule.get(i);
            c[j] = time += this.process[j];
            if (time < this.duedate) {
                earlyTotal += this.earlyWeights[j];
                lastEarly = i;
                continue;
            }
            if (time <= this.duedate) continue;
            tardyTotal += this.weights[j];
            if (firstTardy >= 0) continue;
            firstTardy = i;
        }
        int delay = 0;
        if (lastEarly == firstTardy - 1 && earlyTotal > tardyTotal) {
            j = schedule.get(lastEarly);
            earlyTotal -= this.earlyWeights[j];
            --lastEarly;
            delay = this.duedate - c[j];
        }
        if (firstTardy - lastEarly > 1 || lastEarly == c.length - 2 && firstTardy < 0) {
            int j2;
            for (int notEarlyTotalOfTardy = tardyTotal + this.weights[schedule.get(lastEarly + 1)]; lastEarly >= 0 && earlyTotal >= notEarlyTotalOfTardy; earlyTotal -= this.earlyWeights[j2], notEarlyTotalOfTardy += this.weights[j2], --lastEarly) {
                j2 = schedule.get(lastEarly);
                delay = this.duedate - c[j2];
            }
        }
        if (delay > 0) {
            int i = 0;
            while (i < c.length) {
                int n = i++;
                c[n] = c[n] + delay;
            }
        }
        return c;
    }

    @Override
    public int numberOfJobs() {
        return this.process.length;
    }

    @Override
    public int getProcessingTime(int j) {
        return this.process[j];
    }

    @Override
    public int getDueDate(int j) {
        return this.duedate;
    }

    @Override
    public boolean hasDueDates() {
        return true;
    }

    @Override
    public int getWeight(int j) {
        return this.weights[j];
    }

    @Override
    public boolean hasWeights() {
        return true;
    }

    @Override
    public int getEarlyWeight(int j) {
        return this.earlyWeights[j];
    }

    @Override
    public boolean hasEarlyWeights() {
        return true;
    }

    public void toFile(String filename) throws FileNotFoundException {
        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8), true);
        this.toFile(out);
        out.close();
    }

    void toFile(PrintWriter out) {
        out.println(1);
        out.println(this.process.length);
        for (int i = 0; i < this.process.length; ++i) {
            out.print(this.process[i]);
            out.print("\t");
            out.print(this.earlyWeights[i]);
            out.print("\t");
            out.println(this.weights[i]);
        }
    }

    private void skipInstance(Scanner in) {
        String line = in.nextLine();
        Scanner lineScanner = new Scanner(line);
        int numJobs = lineScanner.nextInt();
        lineScanner.close();
        for (int i = 0; i < numJobs; ++i) {
            in.nextLine();
        }
    }
}

