/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SchedulingHeuristic;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.problems.scheduling.WeightedShortestProcessingTime;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;

public final class DynamicATCS
extends WeightedShortestProcessingTime {
    private final double k1;
    private final double k2;
    private final int pSum;
    private final int sSum;

    public DynamicATCS(SingleMachineSchedulingProblem problem, double k1, double k2) {
        super(problem);
        if (!this.data.hasDueDates()) {
            throw new IllegalArgumentException("This heuristic requires due dates.");
        }
        if (k1 <= 0.0 || k2 <= 0.0) {
            throw new IllegalArgumentException("k1 and k2 must be positive");
        }
        this.pSum = this.sumOfProcessingTimes();
        this.sSum = this.sumOfSetupTimes();
        this.k1 = k1;
        this.k2 = k2;
    }

    public DynamicATCS(SingleMachineSchedulingProblem problem) {
        super(problem);
        if (!this.data.hasDueDates()) {
            throw new IllegalArgumentException("This heuristic requires due dates.");
        }
        int n = this.data.numberOfJobs();
        this.pSum = this.sumOfProcessingTimes();
        this.sSum = this.sumOfSetupTimes();
        double cv = 0.0;
        double eta = 0.0;
        double cmax = this.pSum;
        if (this.sSum > 0) {
            double meanS = (double)this.sSum / (double)(n * n);
            eta = (double)n * meanS / (double)this.pSum;
            cv = this.setupVariance(meanS) / (meanS * meanS);
            if (cv < 1.0E-10) {
                cv = 0.0;
            } else if (cv > 0.3333333333) {
                cv = 0.3333333333;
            }
            double BETA_MIN = n < 153 ? -0.097 * Math.log(n) + 0.6876 : 0.2;
            double BETA = cv == 0.0 ? 1.0 : 1.0 - (1.0 - BETA_MIN) * cv / 0.3333333333;
            cmax += (double)n * meanS * BETA;
        }
        double[] d_stats = this.computeDueDateStats();
        double R = (d_stats[1] - d_stats[0]) / cmax;
        double tau = 1.0 - d_stats[2] / cmax;
        this.k1 = R <= 0.5 ? 4.5 + R : (R <= 2.5 ? 6.0 - R - R : 1.0);
        double temp = eta > 0.0 && tau > 0.0 ? 0.5 * tau / Math.sqrt(eta) : 1.0;
        this.k2 = temp >= 1.0 ? temp : 1.0;
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        double value = super.h(p, element, incEval);
        if (value > 1.0E-5) {
            double denom;
            double num = this.data.getDueDate(element) - this.data.getProcessingTime(element) - ((IncrementalStatsCalculator)incEval).currentTime();
            if (num > 0.0 && (value *= Math.exp(-num / (denom = this.k1 * ((IncrementalStatsCalculator)incEval).averageProcessingTime()))) <= 1.0E-5) {
                return 1.0E-5;
            }
            if (this.HAS_SETUPS && this.sSum > 0) {
                double d = num = p.size() == 0 ? (double)this.data.getSetupTime(element) : (double)this.data.getSetupTime(p.getLast(), element);
                if (num > 0.0 && (value *= Math.exp(-num / (denom = this.k2 * ((IncrementalStatsCalculator)incEval).averageSetupTime()))) <= 1.0E-5) {
                    return 1.0E-5;
                }
            }
        }
        return value;
    }

    @Override
    public IncrementalEvaluation<Permutation> createIncrementalEvaluation() {
        return new IncrementalStatsCalculator(this.pSum, this.sSum);
    }

    private double[] computeDueDateStats() {
        int min;
        int max = min = this.data.getDueDate(0);
        int sum = min;
        int n = this.data.numberOfJobs();
        for (int i = 1; i < n; ++i) {
            int d = this.data.getDueDate(i);
            if (d < min) {
                min = d;
            } else if (d > max) {
                max = d;
            }
            sum += d;
        }
        return new double[]{min, max, (double)sum / (double)n};
    }

    private double setupVariance(double mean) {
        int n = this.data.numberOfJobs();
        double total = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int s = this.data.getSetupTime(i, j);
                total += (double)(s * s);
            }
        }
        return total / (double)(n * n) - mean * mean;
    }

    class IncrementalStatsCalculator
    extends SchedulingHeuristic.IncrementalAverageProcessingCalculator {
        private int totalS;

        public IncrementalStatsCalculator(int pSum, int sSum) {
            super(DynamicATCS.this, pSum);
            this.totalS = sSum;
        }

        @Override
        public void extend(Partial<Permutation> p, int element) {
            super.extend(p, element);
            int x = p.numExtensions();
            for (int i = 0; i < x; ++i) {
                int j = p.getExtension(i);
                this.totalS = p.size() == 0 ? (this.totalS -= DynamicATCS.this.data.getSetupTime(j)) : (this.totalS -= DynamicATCS.this.data.getSetupTime(p.getLast(), j));
                if (j == element) continue;
                this.totalS -= DynamicATCS.this.data.getSetupTime(j, element);
            }
        }

        public double averageSetupTime() {
            if (this.n == 0) {
                return 0.0;
            }
            return (double)this.totalS / (double)(this.n * this.n);
        }
    }
}

