/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SchedulingHeuristic;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;

public final class ExponentialEarlyTardyHeuristic
extends SchedulingHeuristic {
    private final double[] wlpt;
    private final double[] wspt;
    private final double k;
    private final double shift;
    private final int totalProcessTime;

    public ExponentialEarlyTardyHeuristic(SingleMachineSchedulingProblem problem) {
        this(problem, 1.0);
    }

    public ExponentialEarlyTardyHeuristic(SingleMachineSchedulingProblem problem, double k) {
        super(problem);
        if (k < 1.0) {
            throw new IllegalArgumentException("k must be at least 1");
        }
        this.wlpt = new double[this.data.numberOfJobs()];
        this.wspt = new double[this.data.numberOfJobs()];
        double minimum = 0.0;
        for (int i = 0; i < this.wlpt.length; ++i) {
            this.wlpt[i] = (double)(-this.data.getEarlyWeight(i)) / (double)this.data.getProcessingTime(i);
            if (this.wlpt[i] < minimum) {
                minimum = this.wlpt[i];
            }
            this.wspt[i] = (double)this.data.getWeight(i) / (double)this.data.getProcessingTime(i);
        }
        this.shift = 1.0E-5 - minimum;
        this.k = k;
        this.totalProcessTime = this.sumOfProcessingTimes();
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        double slack = ((SchedulingHeuristic.IncrementalAverageProcessingCalculator)incEval).slack(element, p);
        if (slack <= 0.0) {
            return this.wspt[element] + this.shift;
        }
        double kpBar = this.k * ((SchedulingHeuristic.IncrementalAverageProcessingCalculator)incEval).averageProcessingTime();
        if (slack >= kpBar) {
            return this.wlpt[element] + this.shift;
        }
        double bound1 = kpBar * this.wspt[element] / (this.wspt[element] - this.wlpt[element]);
        if (slack <= bound1) {
            return this.wspt[element] * Math.exp(slack * (this.wspt[element] - this.wlpt[element]) / (this.wlpt[element] * kpBar)) + this.shift;
        }
        double numTerm = this.wspt[element] - slack * (this.wspt[element] - this.wlpt[element]) / kpBar;
        return numTerm * numTerm * numTerm / (this.wlpt[element] * this.wlpt[element]) + this.shift;
    }

    @Override
    public IncrementalEvaluation<Permutation> createIncrementalEvaluation() {
        return new SchedulingHeuristic.IncrementalAverageProcessingCalculator(this, this.totalProcessTime);
    }
}

