/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SchedulingHeuristic;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;

public final class LinearEarlyTardyHeuristic
extends SchedulingHeuristic {
    private final double[] wlpt;
    private final double[] wspt;
    private final double k;
    private final int totalProcessTime;

    public LinearEarlyTardyHeuristic(SingleMachineSchedulingProblem problem) {
        this(problem, 1.0);
    }

    public LinearEarlyTardyHeuristic(SingleMachineSchedulingProblem problem, double k) {
        super(problem);
        if (k < 1.0) {
            throw new IllegalArgumentException("k must be at least 1");
        }
        this.wlpt = new double[this.data.numberOfJobs()];
        this.wspt = new double[this.data.numberOfJobs()];
        double minimum = 0.0;
        for (int i = 0; i < this.wlpt.length; ++i) {
            this.wlpt[i] = (double)(-this.data.getEarlyWeight(i)) / (double)this.data.getProcessingTime(i);
            if (this.wlpt[i] < minimum) {
                minimum = this.wlpt[i];
            }
            this.wspt[i] = (double)this.data.getWeight(i) / (double)this.data.getProcessingTime(i);
        }
        double shift = 1.0E-5 - minimum;
        int i = 0;
        while (i < this.wlpt.length) {
            int n = i;
            this.wlpt[n] = this.wlpt[n] + shift;
            int n2 = i++;
            this.wspt[n2] = this.wspt[n2] + shift;
        }
        this.k = k;
        this.totalProcessTime = this.sumOfProcessingTimes();
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        double slack = ((SchedulingHeuristic.IncrementalAverageProcessingCalculator)incEval).slack(element, p);
        if (slack <= 0.0) {
            return this.wspt[element];
        }
        double kpBar = this.k * ((SchedulingHeuristic.IncrementalAverageProcessingCalculator)incEval).averageProcessingTime();
        if (slack >= kpBar) {
            return this.wlpt[element];
        }
        return this.wspt[element] - slack * (this.wspt[element] - this.wlpt[element]) / kpBar;
    }

    @Override
    public IncrementalEvaluation<Permutation> createIncrementalEvaluation() {
        return new SchedulingHeuristic.IncrementalAverageProcessingCalculator(this, this.totalProcessTime);
    }
}

