/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblemData;

public final class MinimizeMakespan
implements SingleMachineSchedulingProblem {
    private final SingleMachineSchedulingProblemData instanceData;
    private int lowerBound;

    public MinimizeMakespan(SingleMachineSchedulingProblemData instanceData) {
        this.instanceData = instanceData;
        int n = instanceData.numberOfJobs();
        this.lowerBound = 0;
        for (int i = 0; i < n; ++i) {
            this.lowerBound += instanceData.getProcessingTime(i);
        }
    }

    @Override
    public SingleMachineSchedulingProblemData getInstanceData() {
        return this.instanceData;
    }

    @Override
    public int cost(Permutation candidate) {
        int[] c = this.instanceData.getCompletionTimes(candidate);
        return c[candidate.get(candidate.length() - 1)];
    }

    @Override
    public int value(Permutation candidate) {
        return this.cost(candidate);
    }

    @Override
    public int minCost() {
        return this.lowerBound;
    }
}

