/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SchedulingHeuristic;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.problems.scheduling.WeightedShortestProcessingTime;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;

public final class Montagne
extends WeightedShortestProcessingTime {
    private final int totalProcessTime;

    public Montagne(SingleMachineSchedulingProblem problem) {
        super(problem);
        if (!this.data.hasDueDates()) {
            throw new IllegalArgumentException("This heuristic requires due dates.");
        }
        this.totalProcessTime = this.sumOfProcessingTimes();
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        double value = super.h(p, element, incEval);
        if (value > 1.0E-5) {
            return (value *= 1.0 - (double)this.data.getDueDate(element) / (double)((SchedulingHeuristic.IncrementalAverageProcessingCalculator)incEval).totalProcessingTime()) <= 1.0E-5 ? 1.0E-5 : value;
        }
        return value;
    }

    @Override
    public IncrementalEvaluation<Permutation> createIncrementalEvaluation() {
        return new SchedulingHeuristic.IncrementalAverageProcessingCalculator(this.totalProcessTime);
    }
}

