/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.Problem;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblemData;
import org.cicirello.search.ss.ConstructiveHeuristic;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;
import org.cicirello.search.ss.PartialPermutation;

abstract class SchedulingHeuristic
implements ConstructiveHeuristic<Permutation> {
    public static final double MIN_H = 1.0E-5;
    final SingleMachineSchedulingProblem problem;
    final SingleMachineSchedulingProblemData data;
    final boolean HAS_SETUPS;

    public SchedulingHeuristic(SingleMachineSchedulingProblem problem) {
        this.problem = problem;
        this.data = problem.getInstanceData();
        this.HAS_SETUPS = this.data.hasSetupTimes();
    }

    @Override
    public final Problem<Permutation> getProblem() {
        return this.problem;
    }

    @Override
    public final Partial<Permutation> createPartial(int n) {
        return new PartialPermutation(n);
    }

    @Override
    public final int completeLength() {
        return this.data.numberOfJobs();
    }

    int sumOfProcessingTimes() {
        int total = 0;
        int n = this.data.numberOfJobs();
        for (int i = 0; i < n; ++i) {
            total += this.data.getProcessingTime(i);
        }
        return total;
    }

    int sumOfSetupTimes() {
        if (!this.HAS_SETUPS) {
            return 0;
        }
        int total = 0;
        int n = this.data.numberOfJobs();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                total += this.data.getSetupTime(i, j);
            }
        }
        return total;
    }

    class IncrementalAverageProcessingCalculator
    extends IncrementalTimeCalculator {
        private int totalP;
        int n;

        public IncrementalAverageProcessingCalculator(int sumOfP) {
            this.n = SchedulingHeuristic.this.data.numberOfJobs();
            this.totalP = sumOfP;
        }

        @Override
        public void extend(Partial<Permutation> p, int element) {
            super.extend(p, element);
            this.totalP -= SchedulingHeuristic.this.data.getProcessingTime(element);
            --this.n;
        }

        public int totalProcessingTime() {
            return this.totalP;
        }

        public double averageProcessingTime() {
            return (double)this.totalP / (double)this.n;
        }
    }

    class IncrementalTimeCalculator
    implements IncrementalEvaluation<Permutation> {
        private int currentTime;

        IncrementalTimeCalculator() {
        }

        @Override
        public void extend(Partial<Permutation> p, int element) {
            this.currentTime += SchedulingHeuristic.this.data.getProcessingTime(element);
            if (SchedulingHeuristic.this.HAS_SETUPS) {
                this.currentTime += p.size() == 0 ? SchedulingHeuristic.this.data.getSetupTime(element) : SchedulingHeuristic.this.data.getSetupTime(p.getLast(), element);
            }
        }

        public final int currentTime() {
            return this.currentTime;
        }

        public final int slack(int element) {
            return SchedulingHeuristic.this.data.getDueDate(element) - this.currentTime - SchedulingHeuristic.this.data.getProcessingTime(element);
        }

        public final int slack(int element, Partial<Permutation> p) {
            int s = this.slack(element);
            if (SchedulingHeuristic.this.HAS_SETUPS) {
                s -= p.size() == 0 ? SchedulingHeuristic.this.data.getSetupTime(element) : SchedulingHeuristic.this.data.getSetupTime(p.getLast(), element);
            }
            return s;
        }

        public final int slackPlus(int element) {
            int s = this.slack(element);
            return s > 0 ? s : 0;
        }

        public final int slackPlus(int element, Partial<Permutation> p) {
            int s = this.slack(element);
            if (SchedulingHeuristic.this.HAS_SETUPS && s > 0) {
                s -= p.size() == 0 ? SchedulingHeuristic.this.data.getSetupTime(element) : SchedulingHeuristic.this.data.getSetupTime(p.getLast(), element);
            }
            return s > 0 ? s : 0;
        }
    }
}

