/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SchedulingHeuristic;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;

public final class SmallestNormalizedSetup
extends SchedulingHeuristic {
    public SmallestNormalizedSetup(SingleMachineSchedulingProblem problem) {
        super(problem);
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        if (this.HAS_SETUPS) {
            int n = p.numExtensions();
            if (n == 1) {
                return 0.5;
            }
            double s = p.size() == 0 ? this.data.getSetupTime(element) : this.data.getSetupTime(p.getLast(), element);
            if (s == 0.0) {
                return 1.0;
            }
            double aveS = s;
            for (int i = 0; i < n; ++i) {
                int k = p.getExtension(i);
                if (k == element) continue;
                aveS += (double)this.data.getSetupTime(k, element);
            }
            double denominator = 1.0 + s / (aveS /= (double)n);
            double h = 1.0 / denominator;
            return h <= 1.0E-5 ? 1.0E-5 : h;
        }
        return 1.0;
    }
}

