/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import java.util.Arrays;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SchedulingHeuristic;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;

public final class SmallestSetupPrecompute
extends SchedulingHeuristic {
    private final double[][] h;

    public SmallestSetupPrecompute(SingleMachineSchedulingProblem problem) {
        super(problem);
        int n = this.data.numberOfJobs();
        this.h = new double[n][n];
        if (this.HAS_SETUPS) {
            for (int i = 0; i < n; ++i) {
                this.h[i][i] = Math.max(1.0E-5, 1.0 / (1.0 + (double)this.data.getSetupTime(i)));
                for (int j = i + 1; j < n; ++j) {
                    this.h[i][j] = Math.max(1.0E-5, 1.0 / (1.0 + (double)this.data.getSetupTime(i, j)));
                    this.h[j][i] = Math.max(1.0E-5, 1.0 / (1.0 + (double)this.data.getSetupTime(j, i)));
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Arrays.fill(this.h[i], 1.0);
            }
        }
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        return p.size() == 0 ? this.h[element][element] : this.h[p.getLast()][element];
    }
}

