/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SchedulingHeuristic;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.problems.scheduling.WeightedShortestProcessingTime;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;

public final class WeightedCostOverTime
extends WeightedShortestProcessingTime {
    private final double k;

    public WeightedCostOverTime(SingleMachineSchedulingProblem problem, double k) {
        super(problem);
        if (!this.data.hasDueDates()) {
            throw new IllegalArgumentException("This heuristic requires due dates.");
        }
        if (k <= 0.0) {
            throw new IllegalArgumentException("k must be positive");
        }
        this.k = k;
    }

    public WeightedCostOverTime(SingleMachineSchedulingProblem problem) {
        this(problem, 2.0);
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        double s;
        double value = super.h(p, element, incEval);
        if (value > 1.0E-5 && (s = (double)((SchedulingHeuristic.IncrementalTimeCalculator)incEval).slack(element, p)) > 0.0) {
            return (value *= 1.0 - s / (this.k * (double)this.data.getProcessingTime(element))) <= 1.0E-5 ? 1.0E-5 : value;
        }
        return value;
    }

    @Override
    public IncrementalEvaluation<Permutation> createIncrementalEvaluation() {
        return new SchedulingHeuristic.IncrementalTimeCalculator(this);
    }
}

