/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblemData;

public final class WeightedLateness
implements SingleMachineSchedulingProblem {
    private final SingleMachineSchedulingProblemData instanceData;

    public WeightedLateness(SingleMachineSchedulingProblemData instanceData) {
        this.instanceData = instanceData;
        if (!instanceData.hasDueDates()) {
            throw new IllegalArgumentException("This cost function requires due dates.");
        }
    }

    @Override
    public SingleMachineSchedulingProblemData getInstanceData() {
        return this.instanceData;
    }

    @Override
    public int cost(Permutation candidate) {
        int[] c = this.instanceData.getCompletionTimes(candidate);
        int total = 0;
        for (int i = 0; i < c.length; ++i) {
            total += this.instanceData.getWeight(i) * (c[i] - this.instanceData.getDueDate(i));
        }
        return total;
    }

    @Override
    public int value(Permutation candidate) {
        return this.cost(candidate);
    }
}

