/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SchedulingHeuristic;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;

public final class WeightedLongestProcessingTime
extends SchedulingHeuristic {
    private final double[] h;

    public WeightedLongestProcessingTime(SingleMachineSchedulingProblem problem) {
        super(problem);
        this.h = new double[this.data.numberOfJobs()];
        double minimum = 0.0;
        for (int i = 0; i < this.h.length; ++i) {
            this.h[i] = (double)(-this.data.getEarlyWeight(i)) / (double)this.data.getProcessingTime(i);
            if (!(this.h[i] < minimum)) continue;
            minimum = this.h[i];
        }
        double shift = 1.0E-5 - minimum;
        int i = 0;
        while (i < this.h.length) {
            int n = i++;
            this.h[n] = this.h[n] + shift;
        }
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        return this.h[element];
    }
}

