/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SchedulingHeuristic;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;

public class WeightedShortestProcessingPlusSetupTimePrecompute
extends SchedulingHeuristic {
    private final double[][] h;

    public WeightedShortestProcessingPlusSetupTimePrecompute(SingleMachineSchedulingProblem problem) {
        super(problem);
        int n = this.data.numberOfJobs();
        this.h = new double[n][n];
        if (this.HAS_SETUPS) {
            for (int i = 0; i < n; ++i) {
                this.h[i][i] = Math.max(1.0E-5, (double)this.data.getWeight(i) / (double)(this.data.getProcessingTime(i) + this.data.getSetupTime(i)));
                for (int j = i + 1; j < n; ++j) {
                    this.h[i][j] = Math.max(1.0E-5, (double)this.data.getWeight(j) / (double)(this.data.getProcessingTime(j) + this.data.getSetupTime(i, j)));
                    this.h[j][i] = Math.max(1.0E-5, (double)this.data.getWeight(i) / (double)(this.data.getProcessingTime(i) + this.data.getSetupTime(j, i)));
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                double H = Math.max(1.0E-5, (double)this.data.getWeight(i) / (double)this.data.getProcessingTime(i));
                for (int j = 0; j < n; ++j) {
                    this.h[j][i] = H;
                }
            }
        }
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        return p.size() == 0 ? this.h[element][element] : this.h[p.getLast()][element];
    }
}

