/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblemData;

public final class WeightedStaticSchedulingWithSetups
implements SingleMachineSchedulingProblemData {
    public static final int MIN_PROCESS_TIME = 50;
    public static final int MAX_PROCESS_TIME = 150;
    public static final int AVERAGE_PROCESS_TIME = 100;
    public static final int MIN_WEIGHT = 0;
    public static final int MAX_WEIGHT = 10;
    private final int[] process;
    private final int[] duedates;
    private final int[] weights;
    private final int[][] setups;
    private static final int PROCESS_TIME_SPAN = 101;
    private static final int WEIGHT_SPAN = 11;

    public WeightedStaticSchedulingWithSetups(int n, double tau, double r, double eta, long seed) {
        this(n, tau, r, eta, new SplittableRandom(seed));
    }

    public WeightedStaticSchedulingWithSetups(int n, double tau, double r, double eta) {
        this(n, tau, r, eta, new SplittableRandom());
    }

    public WeightedStaticSchedulingWithSetups(String filename) throws FileNotFoundException {
        this(new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8));
    }

    private WeightedStaticSchedulingWithSetups(int n, double tau, double r, double eta, RandomGenerator rand) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if (tau < 0.0 || tau > 1.0) {
            throw new IllegalArgumentException("tau must be in [0.0, 1.0]");
        }
        if (r < 0.0 || r > 1.0) {
            throw new IllegalArgumentException("r must be in [0.0, 1.0]");
        }
        if (eta < 0.0 || eta > 1.0) {
            throw new IllegalArgumentException("eta must be in [0.0, 1.0]");
        }
        this.process = new int[n];
        this.duedates = new int[n];
        this.weights = new int[n];
        this.setups = new int[n][n];
        double AVERAGE_SETUP = 100.0 * eta;
        int SETUP_BOUND = (int)(2.0 * AVERAGE_SETUP) + 1;
        double BETA = n < 153 ? -0.097 * Math.log(n) + 0.6876 : 0.2;
        int totalProcessTime = 0;
        int sumSetupMatrix = 0;
        for (int i = 0; i < n; ++i) {
            this.process[i] = 50 + RandomIndexer.nextInt((int)101, (RandomGenerator)rand);
            totalProcessTime += this.process[i];
            this.weights[i] = 0 + RandomIndexer.nextInt((int)11, (RandomGenerator)rand);
            for (int j = 0; j < n; ++j) {
                this.setups[j][i] = RandomIndexer.nextInt((int)SETUP_BOUND, (RandomGenerator)rand);
                sumSetupMatrix += this.setups[j][i];
            }
        }
        double CMAX = (double)totalProcessTime + BETA * (double)sumSetupMatrix / ((double)n + 1.0);
        double AVERAGE_DUEDATE = CMAX * (1.0 - tau);
        double DUEDATE_RANGE = r * CMAX;
        int AVE_DUEDATE_INT = (int)AVERAGE_DUEDATE;
        int MIN_DUEDATE = (int)(AVERAGE_DUEDATE - r * AVERAGE_DUEDATE);
        int MAX_DUEDATE = (int)(AVERAGE_DUEDATE - r * AVERAGE_DUEDATE + DUEDATE_RANGE);
        int D_SPAN_1 = AVE_DUEDATE_INT - MIN_DUEDATE + 1;
        int D_SPAN_2 = MAX_DUEDATE - AVE_DUEDATE_INT + 1;
        for (int i = 0; i < n; ++i) {
            if (!(AVERAGE_DUEDATE > 0.0)) continue;
            this.duedates[i] = rand.nextDouble() < tau ? MIN_DUEDATE + RandomIndexer.nextInt((int)D_SPAN_1, (RandomGenerator)rand) : AVE_DUEDATE_INT + RandomIndexer.nextInt((int)D_SPAN_2, (RandomGenerator)rand);
        }
    }

    WeightedStaticSchedulingWithSetups(Readable file) {
        int i;
        Scanner in = new Scanner(file);
        while (!in.next().equals("Size:")) {
        }
        int n = in.nextInt();
        this.duedates = new int[n];
        this.weights = new int[n];
        this.process = new int[n];
        this.setups = new int[n][n];
        while (!in.nextLine().equals("Process Times:")) {
        }
        for (i = 0; i < n; ++i) {
            this.process[i] = in.nextInt();
        }
        while (!in.hasNextInt()) {
            in.next();
        }
        for (i = 0; i < n; ++i) {
            this.weights[i] = in.nextInt();
        }
        while (!in.hasNextInt()) {
            in.next();
        }
        for (i = 0; i < n; ++i) {
            this.duedates[i] = in.nextInt();
        }
        while (!in.hasNextInt()) {
            in.next();
        }
        while (in.hasNextInt()) {
            i = in.nextInt();
            int j = in.nextInt();
            int setup = in.nextInt();
            if (i == -1) {
                i = j;
            }
            this.setups[i][j] = setup;
        }
        in.close();
    }

    @Override
    public int[] getCompletionTimes(Permutation schedule) {
        if (schedule.length() != this.process.length) {
            throw new IllegalArgumentException("schedule is incorrect length");
        }
        int[] c = new int[this.process.length];
        int last = schedule.get(0);
        int time = 0;
        for (int i = 0; i < c.length; ++i) {
            int j = schedule.get(i);
            c[j] = time += this.process[j] + this.setups[last][j];
            last = j;
        }
        return c;
    }

    @Override
    public int numberOfJobs() {
        return this.weights.length;
    }

    @Override
    public int getProcessingTime(int j) {
        return this.process[j];
    }

    @Override
    public int getDueDate(int j) {
        return this.duedates[j];
    }

    @Override
    public boolean hasDueDates() {
        return true;
    }

    @Override
    public int getWeight(int j) {
        return this.weights[j];
    }

    @Override
    public boolean hasWeights() {
        return true;
    }

    @Override
    public int getSetupTime(int i, int j) {
        return this.setups[i][j];
    }

    @Override
    public int getSetupTime(int j) {
        return this.setups[j][j];
    }

    @Override
    public boolean hasSetupTimes() {
        return true;
    }

    public void toFile(String filename) throws FileNotFoundException {
        this.toFile(filename, -1);
    }

    public void toFile(String filename, int instanceNumber) throws FileNotFoundException {
        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8), true);
        this.toFile(out, instanceNumber);
        out.close();
    }

    void toFile(PrintWriter out, int instanceNumber) {
        out.print("Problem Instance: ");
        out.println(instanceNumber);
        out.print("Problem Size: ");
        out.println(this.numberOfJobs());
        out.println("Begin Generator Parameters");
        out.println("End Generator Parameters");
        out.println("Begin Problem Specification");
        out.println("Process Times:");
        for (int p : this.process) {
            out.println(p);
        }
        out.println("Weights:");
        for (int w : this.weights) {
            out.println(w);
        }
        out.println("Duedates:");
        for (int d : this.duedates) {
            out.println(d);
        }
        out.println("Setup Times:");
        for (int i = 0; i < this.setups.length; ++i) {
            for (int j = 0; j < this.setups[i].length; ++j) {
                if (i == j) {
                    out.printf("%d %d %d\n", -1, j, this.setups[i][j]);
                    continue;
                }
                out.printf("%d %d %d\n", i, j, this.setups[i][j]);
            }
        }
        out.println("End Problem Specification");
    }
}

