/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.tsp;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.Problem;
import org.cicirello.search.problems.tsp.BaseTSP;
import org.cicirello.search.ss.ConstructiveHeuristic;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;
import org.cicirello.search.ss.PartialPermutation;

public final class NearestCityHeuristic
implements ConstructiveHeuristic<Permutation> {
    private final BaseTSP problem;

    public NearestCityHeuristic(BaseTSP problem) {
        this.problem = problem;
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        return p.size() > 0 ? 1.0 / (1.0 + this.problem.edgeCostForHeuristics(p.getLast(), element)) : 1.0;
    }

    @Override
    public final Problem<Permutation> getProblem() {
        return this.problem;
    }

    @Override
    public final Partial<Permutation> createPartial(int n) {
        return new PartialPermutation(n);
    }

    @Override
    public final int completeLength() {
        return this.problem.length();
    }
}

