/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.tsp;

import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.problems.tsp.BaseTSP;

public abstract class RandomTSPMatrix
extends BaseTSP {
    RandomTSPMatrix() {
    }

    public static final class Double
    extends RandomTSPMatrix
    implements OptimizationProblem<Permutation> {
        private final double[][] d;

        public Double(int n, double maxDistance) {
            this(n, maxDistance, true, false);
        }

        public Double(int n, double maxDistance, boolean symmetric) {
            this(n, maxDistance, symmetric, false);
        }

        public Double(int n, double maxDistance, boolean symmetric, boolean triangleInequality) {
            this(n, maxDistance, symmetric, triangleInequality, new SplittableRandom());
        }

        public Double(int n, double maxDistance, boolean symmetric, boolean triangleInequality, long seed) {
            this(n, maxDistance, symmetric, triangleInequality, new SplittableRandom(seed));
        }

        public Double(double[][] distance) {
            int n = distance.length;
            if (n < 2) {
                throw new IllegalArgumentException("distance must be at least 2 by 2");
            }
            this.d = new double[n][n];
            for (int i = 0; i < n; ++i) {
                if (distance[i].length != n) {
                    throw new IllegalArgumentException("num rows and columns must be the same");
                }
                System.arraycopy(distance[i], 0, this.d[i], 0, n);
            }
        }

        private Double(int n, double maxDistance, boolean symmetric, boolean triangleInequality, RandomGenerator gen) {
            if (n < 2) {
                throw new IllegalArgumentException("n must be at least 2");
            }
            if (maxDistance < 0.0) {
                throw new IllegalArgumentException("maxDistance must be non-negative");
            }
            this.d = new double[n][n];
            if (symmetric) {
                this.symmetricInitD(maxDistance + Math.ulp(maxDistance), gen);
                if (triangleInequality) {
                    this.symmetricCloseUnderShortestPaths();
                }
            } else {
                this.asymmetricInitD(maxDistance + Math.ulp(maxDistance), gen);
                if (triangleInequality) {
                    this.asymmetricCloseUnderShortestPaths();
                }
            }
        }

        public final double getDistance(int i, int j) {
            return this.d[i][j];
        }

        @Override
        public final int length() {
            return this.d.length;
        }

        @Override
        public double cost(Permutation candidate) {
            double total = this.d[candidate.get(candidate.length() - 1)][candidate.get(0)];
            for (int k = 1; k < candidate.length(); ++k) {
                total += this.d[candidate.get(k - 1)][candidate.get(k)];
            }
            return total;
        }

        @Override
        public double value(Permutation candidate) {
            return this.cost(candidate);
        }

        @Override
        public double minCost() {
            return 0.0;
        }

        @Override
        final double edgeCostForHeuristics(int i, int j) {
            return this.d[i][j];
        }

        private void symmetricInitD(double maxDistance, RandomGenerator gen) {
            for (int i = 0; i < this.d.length; ++i) {
                for (int j = i + 1; j < this.d.length; ++j) {
                    double d = gen.nextDouble(maxDistance);
                    this.d[j][i] = d;
                    this.d[i][j] = d;
                }
            }
        }

        private void asymmetricInitD(double maxDistance, RandomGenerator gen) {
            for (int i = 0; i < this.d.length; ++i) {
                for (int j = 0; j < this.d.length; ++j) {
                    if (i == j) continue;
                    this.d[i][j] = gen.nextDouble(maxDistance);
                }
            }
        }

        private void symmetricCloseUnderShortestPaths() {
            boolean changed = true;
            while (changed) {
                changed = false;
                for (int i = 0; i < this.d.length; ++i) {
                    for (int j = i + 1; j < this.d.length; ++j) {
                        for (int k = 0; k < this.d.length; ++k) {
                            double sum;
                            if (k == i || k == j || !(this.d[i][j] > (sum = this.d[i][k] + this.d[k][j]))) continue;
                            double d = sum;
                            this.d[j][i] = d;
                            this.d[i][j] = d;
                            changed = true;
                        }
                    }
                }
            }
        }

        private void asymmetricCloseUnderShortestPaths() {
            boolean changed = true;
            while (changed) {
                changed = false;
                for (int i = 0; i < this.d.length; ++i) {
                    for (int j = 0; j < this.d.length; ++j) {
                        if (i == j) continue;
                        for (int k = 0; k < this.d.length; ++k) {
                            double sum;
                            if (k == i || k == j || !(this.d[i][j] > (sum = this.d[i][k] + this.d[k][j]))) continue;
                            this.d[i][j] = sum;
                            changed = true;
                        }
                    }
                }
            }
        }
    }

    public static final class Integer
    extends RandomTSPMatrix
    implements IntegerCostOptimizationProblem<Permutation> {
        private final int[][] d;

        public Integer(int n, int maxDistance) {
            this(n, maxDistance, true, false);
        }

        public Integer(int n, int maxDistance, boolean symmetric) {
            this(n, maxDistance, symmetric, false);
        }

        public Integer(int n, int maxDistance, boolean symmetric, boolean triangleInequality) {
            this(n, maxDistance, symmetric, triangleInequality, new SplittableRandom());
        }

        public Integer(int n, int maxDistance, boolean symmetric, boolean triangleInequality, long seed) {
            this(n, maxDistance, symmetric, triangleInequality, new SplittableRandom(seed));
        }

        public Integer(int[][] distance) {
            int n = distance.length;
            if (n < 2) {
                throw new IllegalArgumentException("distance must be at least 2 by 2");
            }
            this.d = new int[n][n];
            for (int i = 0; i < n; ++i) {
                if (distance[i].length != n) {
                    throw new IllegalArgumentException("num rows and columns must be the same");
                }
                System.arraycopy(distance[i], 0, this.d[i], 0, n);
            }
        }

        private Integer(int n, int maxDistance, boolean symmetric, boolean triangleInequality, RandomGenerator gen) {
            if (n < 2) {
                throw new IllegalArgumentException("n must be at least 2");
            }
            if (maxDistance < 1) {
                throw new IllegalArgumentException("maxDistance must be at least 1");
            }
            this.d = new int[n][n];
            if (symmetric) {
                this.symmetricInitD(maxDistance, gen);
                if (triangleInequality) {
                    this.symmetricCloseUnderShortestPaths();
                }
            } else {
                this.asymmetricInitD(maxDistance, gen);
                if (triangleInequality) {
                    this.asymmetricCloseUnderShortestPaths();
                }
            }
        }

        public final int getDistance(int i, int j) {
            return this.d[i][j];
        }

        @Override
        public final int length() {
            return this.d.length;
        }

        @Override
        public int cost(Permutation candidate) {
            int total = this.d[candidate.get(candidate.length() - 1)][candidate.get(0)];
            for (int k = 1; k < candidate.length(); ++k) {
                total += this.d[candidate.get(k - 1)][candidate.get(k)];
            }
            return total;
        }

        @Override
        public int value(Permutation candidate) {
            return this.cost(candidate);
        }

        @Override
        public int minCost() {
            return 0;
        }

        @Override
        final double edgeCostForHeuristics(int i, int j) {
            return this.d[i][j];
        }

        private void symmetricInitD(int maxDistance, RandomGenerator gen) {
            for (int i = 0; i < this.d.length; ++i) {
                for (int j = i + 1; j < this.d.length; ++j) {
                    int n = 1 + RandomIndexer.nextInt((int)maxDistance, (RandomGenerator)gen);
                    this.d[j][i] = n;
                    this.d[i][j] = n;
                }
            }
        }

        private void asymmetricInitD(int maxDistance, RandomGenerator gen) {
            for (int i = 0; i < this.d.length; ++i) {
                for (int j = 0; j < this.d.length; ++j) {
                    if (i == j) continue;
                    this.d[i][j] = 1 + RandomIndexer.nextInt((int)maxDistance, (RandomGenerator)gen);
                }
            }
        }

        private void symmetricCloseUnderShortestPaths() {
            boolean changed = true;
            while (changed) {
                changed = false;
                for (int i = 0; i < this.d.length; ++i) {
                    for (int j = i + 1; j < this.d.length; ++j) {
                        for (int k = 0; k < this.d.length; ++k) {
                            int sum;
                            if (k == i || k == j || this.d[i][j] <= (sum = this.d[i][k] + this.d[k][j])) continue;
                            int n = sum;
                            this.d[j][i] = n;
                            this.d[i][j] = n;
                            changed = true;
                        }
                    }
                }
            }
        }

        private void asymmetricCloseUnderShortestPaths() {
            boolean changed = true;
            while (changed) {
                changed = false;
                for (int i = 0; i < this.d.length; ++i) {
                    for (int j = 0; j < this.d.length; ++j) {
                        if (i == j) continue;
                        for (int k = 0; k < this.d.length; ++k) {
                            int sum;
                            if (k == i || k == j || this.d[i][j] <= (sum = this.d[i][k] + this.d[k][j])) continue;
                            this.d[i][j] = sum;
                            changed = true;
                        }
                    }
                }
            }
        }
    }
}

