/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.tsp;

import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.problems.tsp.BaseTSP;
import org.cicirello.search.problems.tsp.TSPEdgeDistance;

public abstract class TSP
extends BaseTSP {
    final double[] x;
    final double[] y;
    final TSPEdgeDistance d;

    TSP(int n, double w, RandomGenerator gen) {
        this(n, w, (x1, y1, x2, y2) -> {
            double deltaX = x1 - x2;
            double deltaY = y1 - y2;
            return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        }, gen);
    }

    TSP(int n, double w, TSPEdgeDistance distance, RandomGenerator gen) {
        if (n < 2) {
            throw new IllegalArgumentException("Must be at least 2 cities.");
        }
        if (w <= 0.0) {
            throw new IllegalArgumentException("Width of region must be positive.");
        }
        this.x = new double[n];
        this.y = new double[n];
        for (int i = 0; i < n; ++i) {
            this.x[i] = gen.nextDouble(w);
            this.y[i] = gen.nextDouble(w);
        }
        this.d = distance;
    }

    TSP(double[] x, double[] y) {
        this(x, y, (double x1, double y1, double x2, double y2) -> {
            double deltaX = x1 - x2;
            double deltaY = y1 - y2;
            return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        });
    }

    TSP(double[] x, double[] y, TSPEdgeDistance distance) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays must be same length.");
        }
        if (x.length < 2) {
            throw new IllegalArgumentException("Must be at least 2 cities.");
        }
        this.x = (double[])x.clone();
        this.y = (double[])y.clone();
        this.d = distance;
    }

    @Override
    public final int length() {
        return this.x.length;
    }

    public final double getX(int i) {
        return this.x[i];
    }

    public final double getY(int i) {
        return this.y[i];
    }

    public static final class IntegerMatrix
    extends TSP
    implements IntegerCostOptimizationProblem<Permutation> {
        private final int[][] weights = this.computeWeights();

        public IntegerMatrix(int n, double w) {
            super(n, w, new SplittableRandom());
        }

        public IntegerMatrix(int n, double w, TSPEdgeDistance distance) {
            super(n, w, distance, new SplittableRandom());
        }

        public IntegerMatrix(int n, double w, long seed) {
            super(n, w, new SplittableRandom(seed));
        }

        public IntegerMatrix(int n, double w, TSPEdgeDistance distance, long seed) {
            super(n, w, distance, new SplittableRandom(seed));
        }

        public IntegerMatrix(double[] x, double[] y) {
            super(x, y);
        }

        public IntegerMatrix(double[] x, double[] y, TSPEdgeDistance distance) {
            super(x, y, distance);
        }

        @Override
        public int cost(Permutation candidate) {
            if (candidate.length() != this.x.length) {
                throw new IllegalArgumentException("Permutation must be same length as number of cities.");
            }
            int total = this.weights[candidate.get(candidate.length() - 1)][candidate.get(0)];
            for (int k = 1; k < candidate.length(); ++k) {
                total += this.weights[candidate.get(k - 1)][candidate.get(k)];
            }
            return total;
        }

        @Override
        public int value(Permutation candidate) {
            return this.cost(candidate);
        }

        @Override
        public int minCost() {
            return 0;
        }

        private int[][] computeWeights() {
            int[][] w = new int[this.x.length][this.x.length];
            for (int i = 0; i < w.length; ++i) {
                for (int j = i + 1; j < w.length; ++j) {
                    int n = this.d.distanceAsInt(this.x[i], this.y[i], this.x[j], this.y[j]);
                    w[j][i] = n;
                    w[i][j] = n;
                }
            }
            return w;
        }

        @Override
        final double edgeCostForHeuristics(int i, int j) {
            return this.weights[i][j];
        }
    }

    public static final class DoubleMatrix
    extends TSP
    implements OptimizationProblem<Permutation> {
        private final double[][] weights = this.computeWeights();

        public DoubleMatrix(int n, double w) {
            super(n, w, new SplittableRandom());
        }

        public DoubleMatrix(int n, double w, TSPEdgeDistance distance) {
            super(n, w, distance, new SplittableRandom());
        }

        public DoubleMatrix(int n, double w, long seed) {
            super(n, w, new SplittableRandom(seed));
        }

        public DoubleMatrix(int n, double w, TSPEdgeDistance distance, long seed) {
            super(n, w, distance, new SplittableRandom(seed));
        }

        public DoubleMatrix(double[] x, double[] y) {
            super(x, y);
        }

        public DoubleMatrix(double[] x, double[] y, TSPEdgeDistance distance) {
            super(x, y, distance);
        }

        @Override
        public double cost(Permutation candidate) {
            if (candidate.length() != this.x.length) {
                throw new IllegalArgumentException("Permutation must be same length as number of cities.");
            }
            double total = this.weights[candidate.get(candidate.length() - 1)][candidate.get(0)];
            for (int k = 1; k < candidate.length(); ++k) {
                total += this.weights[candidate.get(k - 1)][candidate.get(k)];
            }
            return total;
        }

        @Override
        public double value(Permutation candidate) {
            return this.cost(candidate);
        }

        @Override
        public double minCost() {
            return 0.0;
        }

        private double[][] computeWeights() {
            double[][] w = new double[this.x.length][this.x.length];
            for (int i = 0; i < w.length; ++i) {
                for (int j = i + 1; j < w.length; ++j) {
                    double d = this.d.distance(this.x[i], this.y[i], this.x[j], this.y[j]);
                    w[j][i] = d;
                    w[i][j] = d;
                }
            }
            return w;
        }

        @Override
        final double edgeCostForHeuristics(int i, int j) {
            return this.weights[i][j];
        }
    }

    public static final class Integer
    extends TSP
    implements IntegerCostOptimizationProblem<Permutation> {
        public Integer(int n, double w) {
            super(n, w, new SplittableRandom());
        }

        public Integer(int n, double w, TSPEdgeDistance distance) {
            super(n, w, distance, new SplittableRandom());
        }

        public Integer(int n, double w, long seed) {
            super(n, w, new SplittableRandom(seed));
        }

        public Integer(int n, double w, TSPEdgeDistance distance, long seed) {
            super(n, w, distance, new SplittableRandom(seed));
        }

        public Integer(double[] x, double[] y) {
            super(x, y);
        }

        public Integer(double[] x, double[] y, TSPEdgeDistance distance) {
            super(x, y, distance);
        }

        @Override
        public int cost(Permutation candidate) {
            if (candidate.length() != this.x.length) {
                throw new IllegalArgumentException("Permutation must be same length as number of cities.");
            }
            int j = candidate.get(0);
            int i = candidate.get(candidate.length() - 1);
            int total = this.d.distanceAsInt(this.x[i], this.y[i], this.x[j], this.y[j]);
            for (int k = 1; k < candidate.length(); ++k) {
                j = candidate.get(k);
                i = candidate.get(k - 1);
                total += this.d.distanceAsInt(this.x[i], this.y[i], this.x[j], this.y[j]);
            }
            return total;
        }

        @Override
        public int value(Permutation candidate) {
            return this.cost(candidate);
        }

        @Override
        public int minCost() {
            return 0;
        }

        @Override
        final double edgeCostForHeuristics(int i, int j) {
            return this.d.distanceAsInt(this.x[i], this.y[i], this.x[j], this.y[j]);
        }
    }

    public static final class Double
    extends TSP
    implements OptimizationProblem<Permutation> {
        public Double(int n, double w) {
            super(n, w, new SplittableRandom());
        }

        public Double(int n, double w, TSPEdgeDistance distance) {
            super(n, w, distance, new SplittableRandom());
        }

        public Double(int n, double w, long seed) {
            super(n, w, new SplittableRandom(seed));
        }

        public Double(int n, double w, TSPEdgeDistance distance, long seed) {
            super(n, w, distance, new SplittableRandom(seed));
        }

        public Double(double[] x, double[] y) {
            super(x, y);
        }

        public Double(double[] x, double[] y, TSPEdgeDistance distance) {
            super(x, y, distance);
        }

        @Override
        public double cost(Permutation candidate) {
            if (candidate.length() != this.x.length) {
                throw new IllegalArgumentException("Permutation must be same length as number of cities.");
            }
            int j = candidate.get(0);
            int i = candidate.get(candidate.length() - 1);
            double total = this.d.distance(this.x[i], this.y[i], this.x[j], this.y[j]);
            for (int k = 1; k < candidate.length(); ++k) {
                j = candidate.get(k);
                i = candidate.get(k - 1);
                total += this.d.distance(this.x[i], this.y[i], this.x[j], this.y[j]);
            }
            return total;
        }

        @Override
        public double value(Permutation candidate) {
            return this.cost(candidate);
        }

        @Override
        public double minCost() {
            return 0.0;
        }

        @Override
        final double edgeCostForHeuristics(int i, int j) {
            return this.d.distance(this.x[i], this.y[i], this.x[j], this.y[j]);
        }
    }
}

