/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.representations;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.util.Copyable;

public final class BitVector
implements Copyable<BitVector> {
    private final int[] bits;
    private final int bitLength;
    private final int lastIntMask;

    public BitVector(int bitLength) {
        this(bitLength, false);
    }

    public BitVector(int bitLength, boolean randomize) {
        if (bitLength < 0) {
            throw new IllegalArgumentException("bitLength must be non-negative");
        }
        this.bits = new int[bitLength + 31 >> 5];
        this.bitLength = bitLength;
        this.lastIntMask = -1 >>> (this.bits.length << 5) - bitLength;
        if (randomize && this.bits.length > 0) {
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = ThreadLocalRandom.current().nextInt();
            }
            int n = this.bits.length - 1;
            this.bits[n] = this.bits[n] & this.lastIntMask;
        }
    }

    public BitVector(int bitLength, int[] bits) {
        if (bitLength < 0) {
            throw new IllegalArgumentException("bitLength must be non-negative");
        }
        if (bitLength + 31 >> 5 != bits.length) {
            throw new IllegalArgumentException("bits.length is inconsistent with bitLength");
        }
        this.bits = (int[])bits.clone();
        this.bitLength = bitLength;
        this.lastIntMask = -1 >>> (bits.length << 5) - bitLength;
        int n = this.bits.length - 1;
        this.bits[n] = this.bits[n] & this.lastIntMask;
    }

    public BitVector(int bitLength, double p) {
        if (bitLength < 0) {
            throw new IllegalArgumentException("bitLength must be non-negative");
        }
        this.bits = new int[bitLength + 31 >> 5];
        this.bitLength = bitLength;
        this.lastIntMask = -1 >>> (this.bits.length << 5) - bitLength;
        if (bitLength > 0) {
            if (p == 0.5) {
                for (int i = 0; i < this.bits.length; ++i) {
                    this.bits[i] = ThreadLocalRandom.current().nextInt();
                }
                int n = this.bits.length - 1;
                this.bits[n] = this.bits[n] & this.lastIntMask;
            } else if (p >= 1.0) {
                for (int i = 0; i < this.bits.length - 1; ++i) {
                    this.bits[i] = -1;
                }
                this.bits[this.bits.length - 1] = this.lastIntMask;
            } else if (p > 0.0) {
                int[] bitsToSet;
                for (int index : bitsToSet = RandomIndexer.sample((int)bitLength, (double)p)) {
                    int i;
                    int n = i = index >> 5;
                    this.bits[n] = this.bits[n] ^ 1 << index - (i << 5);
                }
            }
        }
    }

    private BitVector(BitVector other) {
        this.bits = (int[])other.bits.clone();
        this.bitLength = other.bitLength;
        this.lastIntMask = other.lastIntMask;
    }

    public static void exchangeBits(BitVector b1, BitVector b2, int firstIndex, int lastIndex) {
        if (firstIndex > lastIndex) {
            int temp = firstIndex;
            firstIndex = lastIndex;
            lastIndex = temp;
        }
        if (b1.bitLength != b2.bitLength) {
            throw new IllegalArgumentException("BitVectors must be same length");
        }
        if (firstIndex < 0 || lastIndex >= b1.bitLength) {
            throw new IndexOutOfBoundsException("index(es) is(are) not in the bounds of the BitVector");
        }
        int firstBlock = firstIndex >> 5;
        int lastBlock = lastIndex >> 5;
        if (firstBlock == lastBlock) {
            int r = lastIndex - firstIndex + 1;
            if (r == 32) {
                int temp = b1.bits[firstBlock];
                b1.bits[firstBlock] = b2.bits[firstBlock];
                b2.bits[firstBlock] = temp;
            } else {
                BitVector.partialBlockSwap(b1, b2, firstBlock, (1 << r) - 1 << (firstIndex & 0x1F));
            }
        } else {
            int r = firstIndex & 0x1F;
            if (r != 0) {
                BitVector.partialBlockSwap(b1, b2, firstBlock, ~((1 << r) - 1));
                ++firstBlock;
            }
            if ((r = lastIndex & 0x1F) != 31) {
                BitVector.partialBlockSwap(b1, b2, lastBlock, (1 << r + 1) - 1);
                --lastBlock;
            }
            for (int i = firstBlock; i <= lastBlock; ++i) {
                int temp = b1.bits[i];
                b1.bits[i] = b2.bits[i];
                b2.bits[i] = temp;
            }
        }
    }

    public static void exchangeBits(BitVector b1, BitVector b2, BitVector mask) {
        if (b1.bitLength != mask.bitLength || b2.bitLength != mask.bitLength) {
            throw new IllegalArgumentException("BitVectors must be same length");
        }
        for (int i = 0; i < mask.bits.length; ++i) {
            BitVector.partialBlockSwap(b1, b2, i, mask.bits[i]);
        }
    }

    private static void partialBlockSwap(BitVector b1, BitVector b2, int index, int swapMask) {
        int keepMask = ~swapMask;
        int temp = b1.bits[index] & swapMask | b2.bits[index] & keepMask;
        b1.bits[index] = b2.bits[index] & swapMask | b1.bits[index] & keepMask;
        b2.bits[index] = temp;
    }

    public boolean allZeros() {
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean allOnes() {
        for (int i = this.bits.length - 2; i >= 0; --i) {
            if (this.bits[i] == -1) continue;
            return false;
        }
        return this.bits.length == 0 || this.bits[this.bits.length - 1] == this.lastIntMask;
    }

    public boolean anyOnes() {
        return !this.allZeros();
    }

    public boolean anyZeros() {
        return !this.allOnes();
    }

    public int length() {
        return this.bitLength;
    }

    public int getBit(int index) {
        if (index < 0 || index >= this.bitLength) {
            throw new IndexOutOfBoundsException("index is not in the bounds of the BitVector");
        }
        int i = index >> 5;
        return this.bits[i] >>> index - (i << 5) & 1;
    }

    public void setBit(int index, int bitValue) {
        if (index < 0 || index >= this.bitLength) {
            throw new IndexOutOfBoundsException("index is not in the bounds of the BitVector");
        }
        this.internalSetBit(index, bitValue);
    }

    private void internalSetBit(int index, int bitValue) {
        int i = index >> 5;
        int value = bitValue & 1;
        if (value == 0) {
            int n = i;
            this.bits[n] = this.bits[n] & ~(1 << index - (i << 5));
        } else {
            int n = i;
            this.bits[n] = this.bits[n] | 1 << index - (i << 5);
        }
    }

    public void flip(int index) {
        int i;
        if (index < 0 || index >= this.bitLength) {
            throw new IndexOutOfBoundsException("index is not in the bounds of the BitVector");
        }
        int n = i = index >> 5;
        this.bits[n] = this.bits[n] ^ 1 << index - (i << 5);
    }

    public boolean isOne(int index) {
        return this.getBit(index) == 1;
    }

    public boolean isZero(int index) {
        return this.getBit(index) == 0;
    }

    public int get32(int i) {
        if (i < 0 || i >= this.bits.length) {
            throw new IndexOutOfBoundsException("i is not in the bounds of the BitVector");
        }
        return this.bits[i];
    }

    public void set32(int i, int block) {
        if (i < 0 || i >= this.bits.length) {
            throw new IndexOutOfBoundsException("i is not in the bounds of the BitVector");
        }
        if (i == this.bits.length - 1) {
            block &= this.lastIntMask;
        }
        this.bits[i] = block;
    }

    public int countOnes() {
        int count = 0;
        for (int i = 0; i < this.bits.length; ++i) {
            int b = this.bits[i];
            b -= b >>> 1 & 0x55555555;
            b = (b & 0x33333333) + (b >>> 2 & 0x33333333);
            b = b + (b >>> 4) & 0xF0F0F0F;
            b += b >>> 8;
            b += b >>> 16;
            count += b & 0x3F;
        }
        return count;
    }

    public int countZeros() {
        return this.bitLength - this.countOnes();
    }

    public void and(BitVector other) {
        if (this.bitLength != other.bitLength) {
            throw new IllegalArgumentException("Both BitVectors must be of same length.");
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & other.bits[i];
        }
    }

    public void or(BitVector other) {
        if (this.bitLength != other.bitLength) {
            throw new IllegalArgumentException("Both BitVectors must be of same length.");
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | other.bits[i];
        }
    }

    public void xor(BitVector other) {
        if (this.bitLength != other.bitLength) {
            throw new IllegalArgumentException("Both BitVectors must be of same length.");
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] ^ other.bits[i];
        }
    }

    public void not() {
        if (this.bits.length > 0) {
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = ~this.bits[i];
            }
            int n = this.bits.length - 1;
            this.bits[n] = this.bits[n] & this.lastIntMask;
        }
    }

    public void shiftLeft(int numBits) {
        if (this.bitLength > 0) {
            if (numBits < this.bitLength) {
                if (numBits >= 32) {
                    int numInts = numBits >> 5;
                    System.arraycopy(this.bits, 0, this.bits, numInts, this.bits.length - numInts);
                    Arrays.fill(this.bits, 0, numInts, 0);
                    int n = this.bits.length - 1;
                    this.bits[n] = this.bits[n] & this.lastIntMask;
                    numBits -= numInts << 5;
                }
                if (numBits > 0) {
                    this.leftUpTo31(numBits);
                }
            } else {
                Arrays.fill(this.bits, 0);
            }
        }
    }

    public void shiftRight(int numBits) {
        if (this.bitLength > 0) {
            if (numBits < this.bitLength) {
                if (numBits >= 32) {
                    int numInts = numBits >> 5;
                    System.arraycopy(this.bits, numInts, this.bits, 0, this.bits.length - numInts);
                    Arrays.fill(this.bits, this.bits.length - numInts, this.bits.length, 0);
                    numBits -= numInts << 5;
                }
                if (numBits > 0) {
                    this.rightUpTo31(numBits);
                }
            } else {
                Arrays.fill(this.bits, 0);
            }
        }
    }

    private void leftUpTo31(int numBits) {
        for (int i = this.bits.length - 1; i > 0; --i) {
            this.bits[i] = this.bits[i] << numBits | this.bits[i - 1] >>> 32 - numBits;
        }
        this.bits[0] = this.bits[0] << numBits;
        int n = this.bits.length - 1;
        this.bits[n] = this.bits[n] & this.lastIntMask;
    }

    private void rightUpTo31(int numBits) {
        for (int i = 0; i < this.bits.length - 1; ++i) {
            this.bits[i] = this.bits[i] >>> numBits | this.bits[i + 1] << 32 - numBits;
        }
        int n = this.bits.length - 1;
        this.bits[n] = this.bits[n] >>> numBits;
    }

    public BitVector copy() {
        return new BitVector(this);
    }

    public boolean equals(Object other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        BitVector b = (BitVector)other;
        return this.bitLength == b.bitLength && Arrays.equals(this.bits, b.bits);
    }

    public int hashCode() {
        int h = this.bitLength;
        for (int i = 0; i < this.bits.length; ++i) {
            h = 31 * h + this.bits[i];
        }
        return h;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.bitLength);
        int blockSize = this.bitLength & 0x1F;
        if (blockSize == 0) {
            blockSize = 32;
        }
        String filler = "0000000000000000000000000000000";
        for (int i = this.bits.length - 1; i >= 0; --i) {
            String str = Integer.toBinaryString(this.bits[i]);
            int numZeros = blockSize - str.length();
            if (numZeros > 0) {
                sb.append(filler.substring(0, numZeros));
            }
            sb.append(str);
            blockSize = 32;
        }
        return sb.toString();
    }

    public BitIterator bitIterator(int k) {
        if (k <= 0 || k > 32) {
            throw new IllegalArgumentException("k is outside the range [1,32]");
        }
        return new BitIterator(k);
    }

    public BitIterator bitIterator() {
        return new BitIterator();
    }

    public final class BitIterator {
        private final int k;
        private final int mask;
        private int count;
        private int index;
        private int remaining;

        private BitIterator(int k) {
            this.k = k;
            this.mask = -1 >>> 32 - k;
            this.remaining = 32;
        }

        private BitIterator() {
            this.k = 1;
            this.mask = 1;
            this.remaining = 32;
        }

        public boolean hasNext() {
            return this.count < BitVector.this.bitLength;
        }

        public int numRemainingBits() {
            return this.count >= BitVector.this.bitLength ? 0 : BitVector.this.bitLength - this.count;
        }

        public int nextBitBlock() {
            int block;
            if (this.count >= BitVector.this.bitLength) {
                throw new IllegalStateException();
            }
            if (this.remaining == 0) {
                ++this.index;
                this.remaining = 32;
            }
            if (this.remaining >= this.k) {
                block = BitVector.this.bits[this.index] >>> 32 - this.remaining & this.mask;
                this.remaining -= this.k;
                this.count += this.k;
            } else {
                block = BitVector.this.bits[this.index] >>> 32 - this.remaining;
                ++this.index;
                if (this.index < BitVector.this.bits.length) {
                    block |= BitVector.this.bits[this.index] << this.remaining & this.mask;
                    this.remaining += 32 - this.k;
                    this.count += this.k;
                } else {
                    this.count += this.k;
                    this.remaining = 0;
                }
            }
            return block;
        }

        public int nextBitBlock(int k) {
            if (k <= 0 || k > 32) {
                throw new IllegalArgumentException("k is outside the range [1,32]");
            }
            if (this.count >= BitVector.this.bitLength) {
                throw new IllegalStateException();
            }
            return this.internalNextBitBlock(k);
        }

        public int[] nextLargeBitBlock(int k) {
            if (this.count + k > BitVector.this.bitLength) {
                throw new IllegalArgumentException("requested more bits than remain");
            }
            int numBlocksOf32 = k >> 5;
            int numExtraBits = k & 0x1F;
            int n = numBlocksOf32;
            if (numExtraBits > 0) {
                ++n;
            }
            int[] block = new int[n];
            for (int i = 0; i < numBlocksOf32; ++i) {
                block[i] = this.internalNextBitBlock(32);
            }
            if (numExtraBits > 0) {
                block[numBlocksOf32] = this.internalNextBitBlock(numExtraBits);
            }
            return block;
        }

        public void skip(int k) {
            if (this.count + k > BitVector.this.bitLength) {
                throw new IllegalArgumentException("requested more bits than remain");
            }
            int numBlocksOf32 = k >> 5;
            if (numBlocksOf32 > 0) {
                this.index += numBlocksOf32;
                this.count += numBlocksOf32 << 5;
            }
            if ((k &= 0x1F) > 0) {
                if (this.remaining >= k) {
                    this.remaining -= k;
                    this.count += k;
                } else {
                    this.remaining = 32 - (k - this.remaining);
                    ++this.index;
                    this.count += k;
                }
            }
        }

        public int nextBit() {
            if (this.count >= BitVector.this.bitLength) {
                throw new IllegalStateException();
            }
            if (this.remaining == 0) {
                ++this.index;
                this.remaining = 32;
            }
            int bit = BitVector.this.bits[this.index] >>> 32 - this.remaining & 1;
            --this.remaining;
            ++this.count;
            return bit;
        }

        private int internalNextBitBlock(int k) {
            int block;
            if (this.remaining == 0) {
                ++this.index;
                this.remaining = 32;
            }
            int mask = -1 >>> 32 - k;
            if (this.remaining >= k) {
                block = BitVector.this.bits[this.index] >>> 32 - this.remaining & mask;
                this.remaining -= k;
                this.count += k;
            } else {
                block = BitVector.this.bits[this.index] >>> 32 - this.remaining;
                ++this.index;
                if (this.index < BitVector.this.bits.length) {
                    block |= BitVector.this.bits[this.index] << this.remaining & mask;
                    this.remaining += 32 - k;
                    this.count += k;
                } else {
                    this.count += k;
                    this.remaining = 0;
                }
            }
            return block;
        }
    }
}

