/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.representations;

import java.util.Arrays;
import org.cicirello.search.representations.BoundedIntegerVector;
import org.cicirello.search.representations.IntegerValued;
import org.cicirello.util.Copyable;

public class IntegerVector
implements IntegerValued,
Copyable<IntegerVector> {
    private final int[] x;

    public IntegerVector(int n) {
        this.x = new int[n];
    }

    public IntegerVector(int[] x) {
        this.x = (int[])x.clone();
    }

    public IntegerVector(IntegerVector other) {
        this.x = (int[])other.x.clone();
    }

    @Override
    public final int length() {
        return this.x.length;
    }

    @Override
    public final int get(int i) {
        return this.x[i];
    }

    @Override
    public final int[] toArray(int[] values) {
        if (values == null || values.length != this.x.length) {
            return (int[])this.x.clone();
        }
        System.arraycopy(this.x, 0, values, 0, values.length);
        return values;
    }

    @Override
    public void set(int i, int value) {
        this.x[i] = value;
    }

    public static void exchange(IntegerVector v1, IntegerVector v2, int firstIndex, int lastIndex) {
        if (firstIndex > lastIndex) {
            int temp = firstIndex;
            firstIndex = lastIndex;
            lastIndex = temp;
        }
        if (IntegerVector.canSimpleExchange(v1, v2)) {
            int N = lastIndex - firstIndex + 1;
            int[] temp = new int[N];
            System.arraycopy(v1.x, firstIndex, temp, 0, N);
            System.arraycopy(v2.x, firstIndex, v1.x, firstIndex, N);
            System.arraycopy(temp, 0, v2.x, firstIndex, N);
        } else {
            for (int i = firstIndex; i <= lastIndex; ++i) {
                int temp = v1.x[i];
                v1.set(i, v2.x[i]);
                v2.set(i, temp);
            }
        }
    }

    private static boolean canSimpleExchange(IntegerVector v1, IntegerVector v2) {
        if (v1 instanceof BoundedIntegerVector) {
            return v2 instanceof BoundedIntegerVector && ((BoundedIntegerVector)v1).sameBounds((BoundedIntegerVector)v2);
        }
        return !(v2 instanceof BoundedIntegerVector);
    }

    public IntegerVector copy() {
        return new IntegerVector(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof IntegerVector)) {
            return false;
        }
        return Arrays.equals(this.x, ((IntegerVector)other).x);
    }

    public int hashCode() {
        return Arrays.hashCode(this.x);
    }
}

