/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.restarts;

import java.util.ArrayList;
import java.util.List;
import org.cicirello.search.restarts.RestartSchedule;

public final class LubyRestarts
implements RestartSchedule {
    private final int a;
    private int u;
    private int v;

    public LubyRestarts() {
        this.a = 1;
        this.v = 1;
        this.u = 1;
    }

    public LubyRestarts(int a) {
        if (a < 1) {
            throw new IllegalArgumentException("a must be positive");
        }
        this.a = a;
        this.v = 1;
        this.u = 1;
    }

    @Override
    public int nextRunLength() {
        int r = this.a * this.v;
        if ((-this.u & this.u) == this.v) {
            ++this.u;
            this.v = 1;
        } else {
            this.v <<= 1;
        }
        return r;
    }

    @Override
    public void reset() {
        this.v = 1;
        this.u = 1;
    }

    @Override
    public LubyRestarts split() {
        return new LubyRestarts(this.a);
    }

    public static List<LubyRestarts> createRestartSchedules(int numThreads) {
        return LubyRestarts.createRestartSchedules(numThreads, 1);
    }

    public static List<LubyRestarts> createRestartSchedules(int numThreads, int a) {
        if (numThreads <= 0) {
            throw new IllegalArgumentException("Must have at least 1 thread.");
        }
        if (a <= 0) {
            throw new IllegalArgumentException("a must be greater than 0");
        }
        ArrayList<LubyRestarts> schedules = new ArrayList<LubyRestarts>(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            schedules.add(new LubyRestarts(a));
        }
        return schedules;
    }
}

