/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.restarts;

import java.util.ArrayList;
import java.util.List;
import org.cicirello.search.restarts.RestartSchedule;

public final class ParallelVariableAnnealingLength
implements RestartSchedule {
    private final int shift;
    private final int shiftLimit;
    private final int r0;
    private int r;

    private ParallelVariableAnnealingLength(int shift, int r0) {
        this.r = this.r0 = r0;
        this.shift = shift;
        this.shiftLimit = 0x40000000 >> shift - 1;
    }

    private ParallelVariableAnnealingLength(ParallelVariableAnnealingLength other) {
        this.r = this.r0 = other.r0;
        this.shift = other.shift;
        this.shiftLimit = other.shiftLimit;
    }

    @Override
    public int nextRunLength() {
        int next = this.r;
        this.r = this.r < this.shiftLimit ? (this.r <<= this.shift) : Integer.MAX_VALUE;
        return next;
    }

    @Override
    public void reset() {
        this.r = this.r0;
    }

    @Override
    public ParallelVariableAnnealingLength split() {
        return new ParallelVariableAnnealingLength(this);
    }

    public static List<ParallelVariableAnnealingLength> createRestartSchedules(int numThreads) {
        return ParallelVariableAnnealingLength.createRestartSchedules(numThreads, 1000);
    }

    public static List<ParallelVariableAnnealingLength> createRestartSchedules(int numThreads, int r0) {
        int i;
        if (numThreads <= 0) {
            throw new IllegalArgumentException("Must have at least 1 thread.");
        }
        if (r0 <= 0) {
            throw new IllegalArgumentException("r0 must be greater than 0");
        }
        ArrayList<ParallelVariableAnnealingLength> schedules = new ArrayList<ParallelVariableAnnealingLength>(numThreads);
        int shift = numThreads < 4 ? numThreads : 4;
        for (i = 0; i < shift; ++i) {
            schedules.add(new ParallelVariableAnnealingLength(shift, r0));
            r0 <<= 1;
        }
        for (i = shift; i < numThreads; ++i) {
            schedules.add(new ParallelVariableAnnealingLength(schedules.get(i - 4)));
        }
        return schedules;
    }
}

