/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.restarts;

import org.cicirello.search.ProgressTracker;
import org.cicirello.search.ReoptimizableMetaheuristic;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.restarts.ConstantRestartSchedule;
import org.cicirello.search.restarts.Multistarter;
import org.cicirello.search.restarts.RestartSchedule;
import org.cicirello.util.Copyable;

public final class ReoptimizableMultistarter<T extends Copyable<T>>
extends Multistarter<T>
implements ReoptimizableMetaheuristic<T> {
    private final ReoptimizableMetaheuristic<T> search;

    public ReoptimizableMultistarter(ReoptimizableMetaheuristic<T> search, RestartSchedule r) {
        super(search, r);
        this.search = search;
    }

    public ReoptimizableMultistarter(ReoptimizableMetaheuristic<T> search, int runLength) {
        super(search, new ConstantRestartSchedule(runLength));
        this.search = search;
    }

    @Override
    public SolutionCostPair<T> reoptimize(int numRestarts) {
        ProgressTracker tracker = this.search.getProgressTracker();
        SolutionCostPair<T> bestRestart = null;
        for (int i = 0; i < numRestarts && !tracker.isStopped() && !tracker.didFindBest(); ++i) {
            SolutionCostPair<T> thisRestart = this.search.reoptimize(this.r.nextRunLength());
            if (bestRestart != null && (thisRestart == null || thisRestart.compareTo(bestRestart) >= 0)) continue;
            bestRestart = thisRestart;
        }
        return bestRestart;
    }

    @Override
    public ReoptimizableMultistarter<T> split() {
        return new ReoptimizableMultistarter<T>(this.search.split(), (RestartSchedule)this.r.split());
    }
}

