/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.sa;

import java.util.Arrays;
import org.cicirello.search.sa.AnnealingSchedule;

public final class AcceptanceTracker
implements AnnealingSchedule {
    private final AnnealingSchedule schedule;
    private int[] acceptanceCounts;
    private int[] numRuns;
    private int iteration;

    public AcceptanceTracker(AnnealingSchedule schedule) {
        this.schedule = schedule;
    }

    public double getAcceptanceRate(int iterationIndex) {
        if (this.acceptanceCounts[iterationIndex] == 0) {
            return 0.0;
        }
        return (double)this.acceptanceCounts[iterationIndex] / (double)this.numRuns[iterationIndex];
    }

    public void reset(int maxEvals) {
        if (maxEvals <= 0) {
            throw new IllegalArgumentException("maxEvals must be positive");
        }
        if (this.acceptanceCounts == null || this.acceptanceCounts.length != maxEvals) {
            this.acceptanceCounts = new int[maxEvals];
            this.numRuns = new int[maxEvals];
        } else {
            Arrays.fill(this.acceptanceCounts, 0);
            Arrays.fill(this.numRuns, 0);
        }
    }

    @Override
    public void init(int maxEvals) {
        this.schedule.init(maxEvals);
        if (this.acceptanceCounts == null || this.acceptanceCounts.length != maxEvals) {
            this.reset(maxEvals);
        }
        this.iteration = 0;
    }

    @Override
    public boolean accept(double neighborCost, double currentCost) {
        boolean didAccept = this.schedule.accept(neighborCost, currentCost);
        if (this.iteration < this.acceptanceCounts.length) {
            if (didAccept) {
                int n = this.iteration;
                this.acceptanceCounts[n] = this.acceptanceCounts[n] + 1;
            }
            int n = this.iteration++;
            this.numRuns[n] = this.numRuns[n] + 1;
        }
        return didAccept;
    }

    @Override
    public AcceptanceTracker split() {
        return new AcceptanceTracker((AnnealingSchedule)this.schedule.split());
    }
}

