/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.sa;

import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.search.sa.AnnealingSchedule;

public final class ModifiedLam
implements AnnealingSchedule {
    private double t;
    private double acceptRate;
    private double targetRate;
    private double phase1;
    private double phase2;
    private int iterationCount;
    private double termPhase1;
    private double multPhase1;
    private double multPhase3;
    private int lastMaxEvals = -1;

    @Override
    public void init(int maxEvals) {
        this.t = 0.5;
        this.acceptRate = 0.5;
        this.targetRate = 1.0;
        this.iterationCount = 0;
        this.termPhase1 = 0.56;
        if (this.lastMaxEvals != maxEvals) {
            this.phase1 = 0.15 * (double)maxEvals;
            this.phase2 = 0.65 * (double)maxEvals;
            this.multPhase1 = Math.pow(560.0, -1.0 / this.phase1);
            this.multPhase3 = Math.pow(440.0, -1.0 / ((double)maxEvals - this.phase2));
            this.lastMaxEvals = maxEvals;
        }
    }

    @Override
    public boolean accept(double neighborCost, double currentCost) {
        boolean doAccept = neighborCost <= currentCost || ThreadLocalRandom.current().nextDouble() < Math.exp((currentCost - neighborCost) / this.t);
        this.updateSchedule(doAccept);
        return doAccept;
    }

    @Override
    public ModifiedLam split() {
        return new ModifiedLam();
    }

    private void updateSchedule(boolean doAccept) {
        this.acceptRate = doAccept ? 0.998 * this.acceptRate + 0.002 : 0.998 * this.acceptRate;
        ++this.iterationCount;
        if ((double)this.iterationCount <= this.phase1) {
            this.termPhase1 *= this.multPhase1;
            this.targetRate = 0.44 + this.termPhase1;
        } else {
            this.targetRate = (double)this.iterationCount > this.phase2 ? (this.targetRate *= this.multPhase3) : 0.44;
        }
        this.t = this.acceptRate > this.targetRate ? (this.t *= 0.999) : (this.t *= 1.001001001001001);
    }

    double getTargetRate() {
        return this.targetRate;
    }

    double getAcceptRate() {
        return this.acceptRate;
    }

    double getTemperature() {
        return this.t;
    }
}

