/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.sa;

import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.search.sa.AnnealingSchedule;

public final class ParameterFreeExponentialCooling
implements AnnealingSchedule {
    private double t;
    private double alpha;
    private int steps;
    private int stepCounter;
    private static final int ESTIMATION_SAMPLE_SIZE = 10;
    private static final double LOG_INITIAL_ACCEPTANCE_PROBABILITY = Math.log(0.95);
    private double costSum;
    private int maxEvals;
    private int numEstSamples;

    @Override
    public void init(int maxEvals) {
        this.maxEvals = maxEvals;
        this.costSum = 0.0;
        this.stepCounter = 0;
        this.numEstSamples = 0;
        this.t = 0.0;
        this.steps = 0;
        this.alpha = 0.0;
    }

    @Override
    public boolean accept(double neighborCost, double currentCost) {
        if (this.numEstSamples < 10) {
            this.estimationStep(neighborCost, currentCost);
            return true;
        }
        boolean doAccept = neighborCost <= currentCost || ThreadLocalRandom.current().nextDouble() < Math.exp((currentCost - neighborCost) / this.t);
        ++this.stepCounter;
        if (this.stepCounter == this.steps && this.t > 0.001) {
            this.stepCounter = 0;
            this.t *= this.alpha;
        }
        return doAccept;
    }

    @Override
    public ParameterFreeExponentialCooling split() {
        return new ParameterFreeExponentialCooling();
    }

    private void estimationStep(double neighborCost, double currentCost) {
        ++this.stepCounter;
        if (neighborCost != currentCost) {
            ++this.numEstSamples;
            this.costSum -= Math.abs(neighborCost - currentCost);
            if (this.numEstSamples == 10) {
                this.t = this.costSum / (10.0 * LOG_INITIAL_ACCEPTANCE_PROBABILITY);
                if (this.t < 0.002) {
                    this.t = 0.002;
                }
                int i = 0;
                int j = 0;
                double base = 0.001 / this.t;
                int remaining = this.maxEvals - this.stepCounter - 1;
                do {
                    int k = (remaining & j) == 0 ? remaining >> i : (remaining >> i) + 1;
                    this.alpha = Math.pow(base, 1.0 / (double)k);
                    ++i;
                    j = j << 1 | 1;
                } while (this.alpha > 0.999);
                this.steps = 1 << i - 1;
                this.stepCounter = 0;
            }
        }
    }

    double getTemperature() {
        return this.t;
    }

    double getAlpha() {
        return this.alpha;
    }

    int getSteps() {
        return this.steps;
    }
}

