/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.sa;

import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.search.sa.AnnealingSchedule;

public final class SelfTuningLam
implements AnnealingSchedule {
    private double t;
    private double acceptRate;
    private double targetRate;
    private double phase0;
    private double phase1;
    private double phase2;
    private int iterationCount;
    private double termPhase1;
    private double multPhase1;
    private double multPhase3;
    private double deltaSum;
    private int sameCostCount;
    private int betterCostCount;
    private double alpha;
    private double beta;
    private int lastMaxEvals = -1;
    private static final double LAM_RATE_001 = 0.9768670788789564;
    private static final double LAM_RATE_002 = 0.9546897506857566;
    private static final double LAM_RATE_01 = 0.8072615745900611;
    private static final double LAM_RATE_02 = 0.6808590431613767;

    @Override
    public void init(int maxEvals) {
        if (maxEvals >= 10000) {
            this.acceptRate = 0.9768670788789564;
            this.targetRate = 0.9768670788789564;
        } else {
            this.acceptRate = 0.8072615745900611;
            this.targetRate = 0.8072615745900611;
        }
        this.termPhase1 = this.acceptRate - 0.44;
        this.sameCostCount = 0;
        this.betterCostCount = 0;
        this.deltaSum = 0.0;
        this.t = 0.5;
        this.iterationCount = 0;
        if (this.lastMaxEvals != maxEvals) {
            if (maxEvals >= 10000) {
                this.phase0 = 0.001 * (double)maxEvals;
                this.alpha = 2.0 / (1.0 + 0.01 * (double)maxEvals);
            } else {
                this.phase0 = 0.01 * (double)maxEvals;
                this.alpha = this.phase0 > 9.0 ? 2.0 / (1.0 + this.phase0) : 0.2;
                this.beta = 0.9;
            }
            this.phase1 = 0.15 * (double)maxEvals;
            this.phase2 = 0.65 * (double)maxEvals;
            this.multPhase1 = Math.pow(560.0, -1.0 / this.phase1);
            this.multPhase3 = Math.pow(440.0, -1.0 / ((double)maxEvals - this.phase2));
            this.lastMaxEvals = maxEvals;
        }
    }

    @Override
    public boolean accept(double neighborCost, double currentCost) {
        ++this.iterationCount;
        if ((double)this.iterationCount <= this.phase0) {
            this.doPhaseZeroUpdate(neighborCost, currentCost);
            return true;
        }
        boolean doAccept = neighborCost <= currentCost || ThreadLocalRandom.current().nextDouble() < Math.exp((currentCost - neighborCost) / this.t);
        this.updateSchedule(doAccept);
        return doAccept;
    }

    @Override
    public SelfTuningLam split() {
        return new SelfTuningLam();
    }

    private void doPhaseZeroUpdate(double neighborCost, double currentCost) {
        double costDelta = currentCost - neighborCost;
        if (costDelta > 0.0) {
            ++this.betterCostCount;
            this.deltaSum += costDelta;
        } else if (costDelta < 0.0) {
            this.deltaSum -= costDelta;
        } else {
            ++this.sameCostCount;
        }
        if ((double)(this.iterationCount + 1) > this.phase0) {
            this.initializeTemperature();
        }
    }

    private void initializeTemperature() {
        double costAverage;
        int acceptedCount = this.sameCostCount + this.betterCostCount;
        double initialAcceptanceRate = acceptedCount != this.iterationCount ? (double)acceptedCount / (double)this.iterationCount : (double)acceptedCount / (1.0 + (double)this.iterationCount);
        double d = costAverage = this.iterationCount == this.sameCostCount ? 1.0 : this.deltaSum / (double)(this.iterationCount - this.sameCostCount);
        if (initialAcceptanceRate < this.acceptRate) {
            double dropRate;
            double denom = Math.log((this.acceptRate - initialAcceptanceRate) / (1.0 - initialAcceptanceRate));
            this.t = -costAverage / denom;
            double d2 = dropRate = this.lastMaxEvals >= 10000 ? 0.9546897506857566 : 0.6808590431613767;
            this.beta = initialAcceptanceRate < dropRate ? Math.pow(denom / Math.log((dropRate - initialAcceptanceRate) / (1.0 - initialAcceptanceRate)), 1.0 / this.phase0) : Math.pow(denom * (this.lastMaxEvals >= 10000 ? -0.260731492877931 : -0.17334743675123146), 1.0 / this.phase0);
        } else {
            this.t = costAverage * (this.lastMaxEvals >= 10000 ? 0.3141120890121576 : 0.18987910472222955);
            this.beta = Math.pow(this.lastMaxEvals >= 10000 ? 0.8300587656396743 : 0.912935823058667, 1.0 / this.phase0);
        }
    }

    private void updateSchedule(boolean doAccept) {
        this.acceptRate = doAccept ? (1.0 - this.alpha) * this.acceptRate + this.alpha : (1.0 - this.alpha) * this.acceptRate;
        if ((double)this.iterationCount <= this.phase1) {
            this.termPhase1 *= this.multPhase1;
            this.targetRate = 0.44 + this.termPhase1;
        } else {
            this.targetRate = (double)this.iterationCount > this.phase2 ? (this.targetRate *= this.multPhase3) : 0.44;
        }
        this.t = this.acceptRate > this.targetRate ? (this.t *= this.beta) : (this.t /= this.beta);
    }

    double getTargetRate() {
        return this.targetRate;
    }

    double getAcceptRate() {
        return this.acceptRate;
    }

    double getTemperature() {
        return this.t;
    }
}

