/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.ss;

import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.ss.AbstractStochasticSampler;
import org.cicirello.search.ss.ConstructiveHeuristic;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;
import org.cicirello.util.Copyable;

public final class HeuristicBiasedStochasticSampling<T extends Copyable<T>>
extends AbstractStochasticSampler<T> {
    private final BiasFunction bias;
    private final ConstructiveHeuristic<T> heuristic;
    private final double[] biases;

    public HeuristicBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic) {
        this(heuristic, false, new ProgressTracker());
    }

    public HeuristicBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic, ProgressTracker<T> tracker) {
        this(heuristic, false, tracker);
    }

    public HeuristicBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic, boolean exponentialBias) {
        this(heuristic, exponentialBias, new ProgressTracker());
    }

    public HeuristicBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic, boolean exponentialBias, ProgressTracker<T> tracker) {
        this(heuristic, exponentialBias ? rank -> Math.exp(-rank) : rank -> 1.0 / (double)rank, tracker);
    }

    public HeuristicBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic, double exponent) {
        this(heuristic, exponent, new ProgressTracker());
    }

    public HeuristicBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic, double exponent, ProgressTracker<T> tracker) {
        this(heuristic, rank -> Math.pow(1.0 / (double)rank, exponent), tracker);
    }

    public HeuristicBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic, BiasFunction bias) {
        this(heuristic, bias, new ProgressTracker());
    }

    public HeuristicBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic, BiasFunction bias, ProgressTracker<T> tracker) {
        super(heuristic.getProblem(), tracker);
        this.bias = bias;
        this.heuristic = heuristic;
        this.biases = this.precomputeBiases(heuristic.completeLength());
    }

    private HeuristicBiasedStochasticSampling(HeuristicBiasedStochasticSampling<T> other) {
        super(other);
        this.bias = other.bias;
        this.heuristic = other.heuristic;
        this.biases = other.biases;
    }

    @Override
    public HeuristicBiasedStochasticSampling<T> split() {
        return new HeuristicBiasedStochasticSampling<T>(this);
    }

    double[] precomputeBiases(int n) {
        double[] biases = new double[n];
        if (n > 0) {
            biases[0] = this.bias.bias(1);
            for (int rank = 2; rank <= n; ++rank) {
                biases[rank - 1] = this.bias.bias(rank) + biases[rank - 2];
            }
        }
        return biases;
    }

    int randomizedSelect(int[] indexes, double[] v, int k, int chosenRank) {
        int first = 0;
        int last = k - 1;
        while (first != last) {
            int pivot = this.randomizedPartition(indexes, v, first, last);
            int j = pivot - first + 1;
            if (chosenRank == j) {
                return indexes[pivot];
            }
            if (chosenRank < j) {
                last = pivot - 1;
                continue;
            }
            first = pivot + 1;
            chosenRank -= j;
        }
        return indexes[first];
    }

    private int randomizedPartition(int[] indexes, double[] v, int first, int last) {
        int pivot = first + RandomIndexer.nextBiasedInt((int)(last - first + 1));
        int temp = indexes[pivot];
        indexes[pivot] = indexes[last];
        indexes[last] = temp;
        int x = indexes[last];
        pivot = first - 1;
        for (int j = first; j < last; ++j) {
            if (!(v[indexes[j]] >= v[x])) continue;
            temp = indexes[++pivot];
            indexes[pivot] = indexes[j];
            indexes[j] = temp;
        }
        temp = indexes[++pivot];
        indexes[pivot] = indexes[last];
        indexes[last] = temp;
        return pivot;
    }

    @Override
    SolutionCostPair<T> sample() {
        IncrementalEvaluation<T> incEval = this.heuristic.createIncrementalEvaluation();
        int n = this.heuristic.completeLength();
        Partial<T> p = this.heuristic.createPartial(n);
        double[] v = new double[n];
        int[] extensions = new int[n];
        ThreadLocalRandom r = ThreadLocalRandom.current();
        while (!p.isComplete()) {
            int k = p.numExtensions();
            if (k == 1) {
                if (incEval != null) {
                    incEval.extend(p, p.getExtension(0));
                }
                p.extend(0);
                continue;
            }
            int chosenRank = 1 + this.select(this.biases, k, r.nextDouble(this.biases[k - 1]));
            for (int i = 0; i < k; ++i) {
                v[i] = this.heuristic.h(p, p.getExtension(i), incEval);
                extensions[i] = i;
            }
            int which = this.randomizedSelect(extensions, v, k, chosenRank);
            if (incEval != null) {
                incEval.extend(p, p.getExtension(which));
            }
            p.extend(which);
        }
        T complete = p.toComplete();
        return this.evaluateAndPackageSolution(complete);
    }

    @FunctionalInterface
    public static interface BiasFunction {
        public double bias(int var1);
    }
}

