/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.ss;

import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.operators.Initializer;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.ss.AbstractStochasticSampler;
import org.cicirello.util.Copyable;

public final class IterativeSampling<T extends Copyable<T>>
extends AbstractStochasticSampler<T> {
    private final Initializer<T> initializer;

    public IterativeSampling(OptimizationProblem<T> problem, Initializer<T> initializer, ProgressTracker<T> tracker) {
        super(problem, tracker);
        if (initializer == null) {
            throw new NullPointerException();
        }
        this.initializer = initializer;
    }

    public IterativeSampling(IntegerCostOptimizationProblem<T> problem, Initializer<T> initializer, ProgressTracker<T> tracker) {
        super(problem, tracker);
        if (initializer == null) {
            throw new NullPointerException();
        }
        this.initializer = initializer;
    }

    public IterativeSampling(OptimizationProblem<T> problem, Initializer<T> initializer) {
        this(problem, initializer, new ProgressTracker());
    }

    public IterativeSampling(IntegerCostOptimizationProblem<T> problem, Initializer<T> initializer) {
        this(problem, initializer, new ProgressTracker());
    }

    private IterativeSampling(IterativeSampling<T> other) {
        super(other);
        this.initializer = (Initializer)other.initializer.split();
    }

    @Override
    public IterativeSampling<T> split() {
        return new IterativeSampling<T>(this);
    }

    @Override
    SolutionCostPair<T> sample() {
        Copyable s = (Copyable)this.initializer.createCandidateSolution();
        return this.evaluateAndPackageSolution(s);
    }
}

