/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.ss;

import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.ss.AbstractStochasticSampler;
import org.cicirello.search.ss.ConstructiveHeuristic;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;
import org.cicirello.util.Copyable;

public final class ValueBiasedStochasticSampling<T extends Copyable<T>>
extends AbstractStochasticSampler<T> {
    private final BiasFunction bias;
    private final ConstructiveHeuristic<T> heuristic;

    public ValueBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic) {
        this(heuristic, null, new ProgressTracker());
    }

    public ValueBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic, ProgressTracker<T> tracker) {
        this(heuristic, null, tracker);
    }

    public ValueBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic, double exponent) {
        this(heuristic, exponent, new ProgressTracker());
    }

    public ValueBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic, double exponent, ProgressTracker<T> tracker) {
        this(heuristic, value -> Math.pow(value, exponent), tracker);
    }

    public ValueBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic, BiasFunction bias) {
        this(heuristic, bias, new ProgressTracker());
    }

    public ValueBiasedStochasticSampling(ConstructiveHeuristic<T> heuristic, BiasFunction bias, ProgressTracker<T> tracker) {
        super(heuristic.getProblem(), tracker);
        this.bias = bias;
        this.heuristic = heuristic;
    }

    private ValueBiasedStochasticSampling(ValueBiasedStochasticSampling<T> other) {
        super(other);
        this.bias = other.bias;
        this.heuristic = other.heuristic;
    }

    @Override
    public ValueBiasedStochasticSampling<T> split() {
        return new ValueBiasedStochasticSampling<T>(this);
    }

    public static BiasFunction createExponentialBias(double scale) {
        return value -> Math.exp(scale * value);
    }

    void adjustForBias(double[] values, int k) {
        int i;
        double total = 0.0;
        if (this.bias != null) {
            for (i = 0; i < k; ++i) {
                values[i] = this.bias.bias(values[i]);
                total += values[i];
            }
        } else {
            for (i = 0; i < k; ++i) {
                total += values[i];
            }
        }
        values[0] = values[0] / total;
        for (i = 1; i < k; ++i) {
            values[i] = values[i - 1] + values[i] / total;
        }
        values[k - 1] = 1.0;
    }

    @Override
    SolutionCostPair<T> sample() {
        IncrementalEvaluation<T> incEval = this.heuristic.createIncrementalEvaluation();
        int n = this.heuristic.completeLength();
        Partial<T> p = this.heuristic.createPartial(n);
        double[] b = new double[n];
        ThreadLocalRandom r = ThreadLocalRandom.current();
        while (!p.isComplete()) {
            int k = p.numExtensions();
            if (k == 1) {
                if (incEval != null) {
                    incEval.extend(p, p.getExtension(0));
                }
                p.extend(0);
                continue;
            }
            for (int i = 0; i < k; ++i) {
                b[i] = this.heuristic.h(p, p.getExtension(i), incEval);
            }
            this.adjustForBias(b, k);
            int which = this.select(b, k, r.nextDouble());
            if (incEval != null) {
                incEval.extend(p, p.getExtension(which));
            }
            p.extend(which);
        }
        T complete = p.toComplete();
        return this.evaluateAndPackageSolution(complete);
    }

    @FunctionalInterface
    public static interface BiasFunction {
        public double bias(double var1);
    }
}

