/*
 * The CIP4 Software License, Version 1.0
 *
 *
 * Copyright (c) 2001-2017 The International Cooperation for the Integration of
 * Processes in  Prepress, Press and Postpress (CIP4).  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        The International Cooperation for the Integration of
 *        Processes in  Prepress, Press and Postpress (www.cip4.org)"
 *    Alternately, this acknowledgment mrSubRefay appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "CIP4" and "The International Cooperation for the Integration of
 *    Processes in  Prepress, Press and Postpress" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact info@cip4.org.
 *
 * 5. Products derived from this software may not be called "CIP4",
 *    nor may "CIP4" appear in their name, without prior writtenrestartProcesses()
 *    permission of the CIP4 organization
 *
 * Usage of this software in commercial products is subject to restrictions. For
 * details please consult info@cip4.org.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE INTERNATIONAL COOPERATION FOR
 * THE INTEGRATION OF PROCESSES IN PREPRESS, PRESS AND POSTPRESS OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIrSubRefAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the The International Cooperation for the Integration
 * of Processes in Prepress, Press and Postpress and was
 * originally based on software restartProcesses()
 * copyright (c) 1999-2001, Heidelberger Druckmaschinen AG
 * copyright (c) 1999-2001, Agfa-Gevaert N.V.
 *
 * For more information on The International Cooperation for the
 * Integration of Processes in  Prepress, Press and Postpress , please see
 * <http://www.cip4.org/>.
 *
 */
package org.cip4.jdflib.extensions;

import org.cip4.jdflib.core.AttributeName;
import org.cip4.jdflib.core.ElementName;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFConstants;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFSubscription;
import org.cip4.jdflib.jmf.JMFBuilder;
import org.cip4.jdflib.jmf.JMFBuilderFactory;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

/**
 * superclass for audits and messages
 *
 * @author Rainer Prosi, Heidelberger Druckmaschinen *
 */
public class MessageHelper extends BaseXJDFHelper
{

	/**
	 * @param audit
	 */
	public MessageHelper(KElement mes)
	{
		theElement = mes;
	}

	/**
	 *
	 * @see org.cip4.jdflib.extensions.BaseXJDFHelper#cleanUp()
	 */
	@Override
	public void cleanUp()
	{
		super.cleanUp();
		ensureHeader(theElement);
		VElement v = theElement.getChildrenByTagName(XJDFConstants.ResourceSet, null, null, false, true, 0);
		if (v != null)
		{
			for (KElement e : v)
			{
				new SetHelper(e).cleanUp();
				e.removeAttribute(AttributeName.ID);
				VElement vRes = e.getChildElementVector(ElementName.RESOURCE, null);
				if (vRes != null)
				{
					for (KElement res : vRes)
					{
						res.removeAttribute(AttributeName.ID);
					}
				}
			}
		}
	}

	/**
	 *
	 * @param message
	 * @return
	 */
	static KElement ensureHeader(KElement message)
	{
		KElement header = message.getCreateElement(XJDFConstants.Header);
		header.appendAnchor(null);
		if (!header.hasAttribute(AttributeName.TIME))
		{
			header.setAttribute(AttributeName.TIME, new JDFDate().getDateTimeISO());
		}
		JMFBuilder jmfBuilder = JMFBuilderFactory.getJMFBuilder(XJDFConstants.XJMF);
		if (!header.hasAttribute(AttributeName.DEVICEID))
		{
			String senderID = jmfBuilder.getSenderID();
			if (StringUtil.getNonEmpty(senderID) == null)
			{
				senderID = JDFJMF.getTheSenderID();
			}
			if (StringUtil.getNonEmpty(senderID) == null)
			{
				senderID = StringUtil.replaceString(JDFAudit.getStaticAgentName(), JDFConstants.BLANK, JDFConstants.UNDERSCORE);
			}
			header.setAttribute(AttributeName.DEVICEID, senderID);
		}
		if (!header.hasAttribute(AttributeName.AGENTNAME))
		{
			header.setAttribute(AttributeName.AGENTNAME, jmfBuilder.getAgentName());
		}
		if (!header.hasAttribute(AttributeName.AGENTVERSION))
		{
			header.setAttribute(AttributeName.AGENTVERSION, jmfBuilder.getAgentVersion());
		}
		return header;
	}

	/**
	 * get the header of this - create if not there yet
	 * @return
	 */
	public KElement getHeader()
	{
		return ensureHeader(theElement);
	}

	/**
	 *
	 * @return
	 */
	public int getReturnCode()
	{
		if (!isResponse())
			return -1;
		String rc = getAttribute(AttributeName.RETURNCODE);
		return StringUtil.parseInt(rc, 0);
	}

	/**
	 *
	 * @param url
	 * @return null if we ain't no query
	 */
	public JDFSubscription subscribe(String url)
	{
		if (!isQuery())
			return null;
		JDFSubscription sub = (JDFSubscription) getCreateElement(ElementName.SUBSCRIPTION);
		sub.setURL(url);
		return sub;
	}

	/**
	 *
	 * @return
	 */
	public boolean isQuery()
	{
		return theElement != null && theElement.getLocalName().startsWith(ElementName.QUERY);
	}

	/**
	 *
	 * @return
	 */
	public static boolean isMessage(KElement element)
	{
		String localName = element == null ? null : element.getLocalName();
		if (localName == null)
		{
			return false;
		}
		return localName.startsWith(ElementName.COMMAND) || localName.startsWith(ElementName.QUERY) || localName.startsWith(ElementName.SIGNAL)
				|| localName.startsWith(ElementName.RESPONSE);
	}

	/**
	 *
	 * @return
	 */
	public boolean isCommand()
	{
		return theElement != null && theElement.getLocalName().startsWith(ElementName.COMMAND);
	}

	/**
	 *
	 * @return
	 */
	public boolean isResponse()
	{
		return theElement != null && theElement.getLocalName().startsWith(ElementName.RESPONSE);
	}

	/**
	 *
	 * @return
	 */
	public boolean isSignal()
	{
		return theElement != null && theElement.getLocalName().startsWith(ElementName.SIGNAL);
	}

	/**
	 *
	 * @param url
	 * @return null if we ain't no query
	 */
	public void setQuery(MessageHelper hQuery)
	{
		if (!isResponse() && !isSignal() || hQuery == null || (hQuery.isResponse() || hQuery.isSignal()))
			return;
		String id = ensureHeader(hQuery.theElement).appendAnchor(null);
		ensureHeader(theElement).setAttribute(AttributeName.REFID, id);
	}

}
