/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import java.util.Map;
import java.util.Optional;
import org.citrusframework.TestAction;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface TestActionBuilder<T extends TestAction> {
    public static final Logger LOG = LoggerFactory.getLogger(TestActionBuilder.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/action/builder";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/action/builder");

    public T build();

    public static Map<String, TestActionBuilder<?>> lookup() {
        Map<String, TestActionBuilder<?>> builders = TYPE_RESOLVER.resolveAll();
        if (LOG.isDebugEnabled()) {
            builders.forEach((k, v) -> LOG.debug(String.format("Found test action builder '%s' as %s", k, v.getClass())));
        }
        return builders;
    }

    public static Optional<TestActionBuilder<?>> lookup(String builder) {
        try {
            return Optional.of((TestActionBuilder)TYPE_RESOLVER.resolve(builder, new Object[0]));
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve test action builder from resource '%s/%s'", RESOURCE_PATH, builder));
            return Optional.empty();
        }
    }

    public static interface DelegatingTestActionBuilder<T extends TestAction>
    extends TestActionBuilder<T> {
        public TestActionBuilder<?> getDelegate();
    }
}

