/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.citrusframework.annotations.CitrusEndpoint;
import org.citrusframework.annotations.CitrusEndpointConfig;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.spi.BindToRegistry;
import org.citrusframework.spi.ReferenceRegistry;
import org.citrusframework.spi.ReferenceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class CitrusEndpointAnnotations {
    private static final Logger LOG = LoggerFactory.getLogger(CitrusEndpointAnnotations.class);

    private CitrusEndpointAnnotations() {
    }

    public static void injectEndpoints(Object target, TestContext context) {
        ReflectionUtils.doWithFields(target.getClass(), field -> {
            LOG.debug(String.format("Injecting Citrus endpoint on test class field '%s'", field.getName()));
            CitrusEndpoint endpointAnnotation = field.getAnnotation(CitrusEndpoint.class);
            for (Annotation annotation : field.getAnnotations()) {
                if (annotation.annotationType().getAnnotation(CitrusEndpointConfig.class) == null) continue;
                Endpoint endpoint = context.getEndpointFactory().create(CitrusEndpointAnnotations.getEndpointName(field), annotation, context);
                ReflectionUtils.setField((Field)field, (Object)target, (Object)endpoint);
                if (field.isAnnotationPresent(BindToRegistry.class)) {
                    context.getReferenceResolver().bind(ReferenceRegistry.getName(field.getAnnotation(BindToRegistry.class), endpoint.getName()), endpoint);
                }
                return;
            }
            ReferenceResolver referenceResolver = context.getReferenceResolver();
            if (endpointAnnotation.properties().length > 0) {
                ReflectionUtils.setField((Field)field, (Object)target, (Object)context.getEndpointFactory().create(CitrusEndpointAnnotations.getEndpointName(field), endpointAnnotation, field.getType(), context));
            } else if (StringUtils.hasText((String)endpointAnnotation.name()) && referenceResolver.isResolvable(endpointAnnotation.name())) {
                ReflectionUtils.setField((Field)field, (Object)target, referenceResolver.resolve(endpointAnnotation.name(), field.getType()));
            } else if (referenceResolver.isResolvable(field.getName())) {
                ReflectionUtils.setField((Field)field, (Object)target, referenceResolver.resolve(field.getName(), field.getType()));
            } else {
                ReflectionUtils.setField((Field)field, (Object)target, referenceResolver.resolve(field.getType()));
            }
        }, field -> {
            if (field.isAnnotationPresent(CitrusEndpoint.class) && Endpoint.class.isAssignableFrom(field.getType())) {
                if (!field.canAccess(target)) {
                    ReflectionUtils.makeAccessible((Field)field);
                }
                return true;
            }
            return false;
        });
    }

    private static String getEndpointName(Field field) {
        if (field.getAnnotation(CitrusEndpoint.class) != null && StringUtils.hasText((String)field.getAnnotation(CitrusEndpoint.class).name())) {
            return field.getAnnotation(CitrusEndpoint.class).name();
        }
        return field.getName();
    }
}

