/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.common;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.citrusframework.TestCase;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TestLoader {
    public static final Logger LOG = LoggerFactory.getLogger(TestLoader.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/test/loader";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/test/loader");
    public static final String XML = "xml";
    public static final String YAML = "yaml";
    public static final String SPRING = "spring";
    public static final String GROOVY = "groovy";

    public void load();

    public void configureTestCase(Consumer<TestCase> var1);

    public void doWithTestCase(Consumer<TestCase> var1);

    public void setTestClass(Class<?> var1);

    public void setTestName(String var1);

    public void setPackageName(String var1);

    public TestCase getTestCase();

    public static Map<String, TestLoader> lookup() {
        Map<String, TestLoader> loader = TYPE_RESOLVER.resolveAll();
        if (LOG.isDebugEnabled()) {
            loader.forEach((k, v) -> LOG.debug(String.format("Found test loader '%s' as %s", k, v.getClass())));
        }
        return loader;
    }

    public static Optional<TestLoader> lookup(String loader) {
        try {
            return Optional.of((TestLoader)TYPE_RESOLVER.resolve(loader, new Object[0]));
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve test loader from resource '%s/%s'", RESOURCE_PATH, loader));
            return Optional.empty();
        }
    }
}

