/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message;

import org.citrusframework.context.TestContext;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageDirection;
import org.citrusframework.message.MessageDirectionAware;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.message.MessageTypeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageProcessor
implements MessageProcessor,
MessageDirectionAware,
MessageTypeSelector {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private MessageDirection direction = MessageDirection.UNBOUND;

    @Override
    public void process(Message message, TestContext context) {
        if (this.supportsMessageType(message.getType())) {
            this.processMessage(message, context);
        } else {
            this.log.debug(String.format("Message processor '%s' skipped for message type: %s", this.getName(), message.getType()));
        }
    }

    protected void processMessage(Message message, TestContext context) {
    }

    @Override
    public boolean supportsMessageType(String messageType) {
        return true;
    }

    protected String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public MessageDirection getDirection() {
        return this.direction;
    }

    public void setDirection(MessageDirection direction) {
        this.direction = direction;
    }
}

